/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanhds.sqlbuilder.delete;

import com.github.jonathanhds.sqlbuilder.Context;
import com.github.jonathanhds.sqlbuilder.IllegalQueryException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;

public class Delete {
    private String table;
    private final Context context;
    private final Collection<String> conditions;
    private boolean terminated = false;

    public Delete(Context context) {
        this.context = context;
        this.context.append("DELETE FROM ");
        this.conditions = new LinkedList<String>();
    }

    public Delete(Context context, String table) {
        this(context);
        this.table = table;
    }

    public Delete where(String condition) {
        this.conditions.add(condition);
        return this;
    }

    public Delete and(String condition) {
        this.conditions.add(condition);
        return this;
    }

    private void terminate() {
        if (StringUtils.isBlank((String)this.table)) {
            throw new IllegalQueryException("No table specified!");
        }
        if (!this.terminated) {
            this.context.append(this.table);
            if (!this.conditions.isEmpty()) {
                this.context.newLine().append("WHERE ");
                Iterator<String> conditionIter = this.conditions.iterator();
                while (conditionIter.hasNext()) {
                    String condition = conditionIter.next();
                    this.context.append(condition);
                    if (!conditionIter.hasNext()) continue;
                    this.context.newLine().append("AND ");
                }
            }
            this.terminated = true;
        }
    }

    public String toString() {
        this.terminate();
        return this.context.toString();
    }
}

