/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanhds.sqlbuilder.insert;

import com.github.jonathanhds.sqlbuilder.Context;
import com.github.jonathanhds.sqlbuilder.IllegalQueryException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Insert {
    private String table;
    private final List<String> columns;
    private final List<Object[]> values;
    private final Context context;
    private boolean terminated = false;

    public Insert(Context context) {
        this.context = context;
        this.context.append("INSERT INTO ");
        this.columns = new LinkedList<String>();
        this.values = new LinkedList<Object[]>();
    }

    public Insert(Context context, String table) {
        this(context);
        this.table = table;
    }

    public Insert table(String table) {
        this.table = table;
        return this;
    }

    public Insert columns(String ... columns) {
        Collections.addAll(this.columns, columns);
        return this;
    }

    public Insert values(Object ... values) {
        this.values.add(values);
        return this;
    }

    public String toString() {
        this.terminate();
        return this.context.toString();
    }

    private void terminate() {
        if (this.columns.isEmpty()) {
            throw new IllegalQueryException("No columns informed!");
        }
        if (this.values.isEmpty()) {
            throw new IllegalQueryException("No values informed!");
        }
        for (Object[] valueSet : this.values) {
            if (valueSet.length == this.columns.size()) continue;
            throw new IllegalQueryException("Value size different from column size!");
        }
        if (!this.terminated) {
            this.context.appendLine(this.table).append(" ( ").append(StringUtils.join(this.columns, (String)", ")).appendLine(" )").append("VALUES ").append(StringUtils.join((Object[])this.getValues(), (String)", "));
        }
    }

    private String[] getValues() {
        String[] result = new String[this.values.size()];
        for (int i = 0; i < result.length; ++i) {
            Object[] objs = this.values.get(i);
            result[i] = this.toValue(objs);
        }
        return result;
    }

    private String toValue(Object[] objs) {
        Object[] result = new String[objs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = objs[i] instanceof String ? "'" + objs[i].toString() + "'" : objs[i].toString();
        }
        return "(" + StringUtils.join((Object[])result, (String)", ") + ")";
    }
}

