/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanhds.sqlbuilder.select;

import com.github.jonathanhds.sqlbuilder.Context;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

abstract class Condition {
    protected final Context context;

    Condition(Context context) {
        this.context = context;
    }

    void add(Object condition) {
        this.context.appendLine(this.getPrefix() + " " + condition);
    }

    void add(Object condition, Object parameter) {
        if (parameter != null) {
            this.add(condition, new Object[]{parameter});
        }
    }

    void add(String condition, String parameter) {
        if (StringUtils.isNotBlank((String)parameter)) {
            this.add((Object)condition, new Object[]{parameter});
        }
    }

    void add(Object condition, Object ... parameters) {
        if (ArrayUtils.isNotEmpty((Object[])parameters)) {
            this.context.addParameters(parameters);
            this.add(condition);
        }
    }

    void between(String columnName, Object start, Object end) {
        if (start == null) {
            if (end == null) {
                return;
            }
            this.add((Object)(columnName + " <= ?"), end);
        } else if (end == null) {
            this.add((Object)(columnName + " >= ?"), start);
        } else {
            this.add((Object)(columnName + " BETWEEN ? AND ?"), start, end);
        }
    }

    protected abstract String getPrefix();
}

