/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanhds.sqlbuilder.select;

import com.github.jonathanhds.sqlbuilder.Context;
import com.github.jonathanhds.sqlbuilder.TerminalExpression;
import com.github.jonathanhds.sqlbuilder.select.GroupBy;
import com.github.jonathanhds.sqlbuilder.select.InnerJoin;
import com.github.jonathanhds.sqlbuilder.select.Join;
import com.github.jonathanhds.sqlbuilder.select.LeftOuterJoin;
import com.github.jonathanhds.sqlbuilder.select.Limit;
import com.github.jonathanhds.sqlbuilder.select.OrderBy;
import com.github.jonathanhds.sqlbuilder.select.RightOuterJoin;
import com.github.jonathanhds.sqlbuilder.select.RowMapper;
import com.github.jonathanhds.sqlbuilder.select.Where;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class From
implements TerminalExpression {
    private Context context;
    private boolean terminated = false;
    private final List<String> tables = new ArrayList<String>();

    From(Context context) {
        this.context = context;
        this.context.appendLine("FROM");
    }

    public From table(String table) {
        this.tables.add(table);
        return this;
    }

    public From tables(String ... tables) {
        this.tables.addAll(Arrays.asList(tables));
        return this;
    }

    public From select(String selectQuery, String alias) {
        this.tables.add("(" + selectQuery + ") " + alias);
        return this;
    }

    public Where where() {
        this.terminate();
        return new Where(this.context);
    }

    public Where where(String condition) {
        this.terminate();
        return new Where(this.context, condition);
    }

    public GroupBy groupBy() {
        this.terminate();
        return new GroupBy(this.context);
    }

    public GroupBy groupBy(String ... columns) {
        this.terminate();
        return new GroupBy(this.context, columns);
    }

    public Join leftOuterJoin(String condition) {
        this.terminate();
        return new LeftOuterJoin(this.context, condition);
    }

    public Join rightOuterJoin(String condition) {
        this.terminate();
        return new RightOuterJoin(this.context, condition);
    }

    public Join innerJoin(String condition) {
        this.terminate();
        return new InnerJoin(this.context, condition);
    }

    public OrderBy orderBy() {
        this.terminate();
        return new OrderBy(this.context);
    }

    public Limit limit(int start, int size) {
        this.terminate();
        return new Limit(this.context, start, size);
    }

    @Override
    public <E> List<E> list(RowMapper<E> rowMapper) throws SQLException {
        this.terminate();
        return this.context.list(rowMapper);
    }

    @Override
    public <E> E single(RowMapper<E> rowMapper) throws SQLException {
        this.terminate();
        return this.context.single(rowMapper);
    }

    public String toString() {
        this.terminate();
        return this.context.toString();
    }

    private void terminate() {
        if (!this.terminated) {
            String newLine = System.getProperty("line.separator");
            this.context.appendLine(StringUtils.join(this.tables, (String)("," + newLine)));
            this.context.appendLine(newLine);
            this.terminated = true;
        }
    }
}

