/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanhds.sqlbuilder.select;

import com.github.jonathanhds.sqlbuilder.Context;
import com.github.jonathanhds.sqlbuilder.TerminalExpression;
import com.github.jonathanhds.sqlbuilder.select.Having;
import com.github.jonathanhds.sqlbuilder.select.OrderBy;
import com.github.jonathanhds.sqlbuilder.select.OrderByType;
import com.github.jonathanhds.sqlbuilder.select.RowMapper;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GroupBy
implements TerminalExpression {
    private final Context context;
    private final List<String> columns;
    private boolean terminated = false;

    GroupBy(Context context) {
        this.context = context;
        context.appendLine("GROUP BY");
        this.columns = new LinkedList<String>();
    }

    GroupBy(Context context, String ... columns) {
        this(context);
        this.columns.addAll(Arrays.asList(columns));
    }

    public GroupBy column(String column) {
        this.columns.add(column);
        return this;
    }

    public GroupBy columns(String ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    public Having having() {
        this.terminate();
        return new Having(this.context);
    }

    public Having having(String condition) {
        this.terminate();
        return new Having(this.context, condition);
    }

    public OrderBy orderBy() {
        this.terminate();
        return new OrderBy(this.context);
    }

    public OrderBy orderBy(String ... columns) {
        this.terminate();
        return new OrderBy(this.context, columns);
    }

    public OrderBy orderBy(OrderByType order, String ... columns) {
        this.terminate();
        return new OrderBy(this.context, order, columns);
    }

    public OrderBy orderBy(String column, OrderByType order) {
        this.terminate();
        return new OrderBy(this.context, order, column);
    }

    @Override
    public <E> List<E> list(RowMapper<E> rowMapper) throws SQLException {
        this.terminate();
        return this.context.list(rowMapper);
    }

    @Override
    public <E> E single(RowMapper<E> rowMapper) throws SQLException {
        this.terminate();
        return this.context.single(rowMapper);
    }

    public String toString() {
        this.terminate();
        return this.context.toString();
    }

    private void terminate() {
        if (!this.terminated) {
            this.context.appendLine(StringUtils.join(this.columns, (String)", "));
            this.terminated = true;
        }
    }
}

