/*
 * Decompiled with CFR 0.152.
 */
package com.github.jscookie.javacookie;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jscookie.javacookie.AttributesDefinition;
import com.github.jscookie.javacookie.ConverterException;
import com.github.jscookie.javacookie.ConverterStrategy;
import com.github.jscookie.javacookie.CookieParseException;
import com.github.jscookie.javacookie.CookieSerializationException;
import com.github.jscookie.javacookie.CookieValue;
import com.github.jscookie.javacookie.CookiesDefinition;
import com.github.jscookie.javacookie.Expiration;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class Cookies
implements CookiesDefinition {
    private static String UTF_8 = "UTF-8";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private AttributesDefinition defaults = Attributes.empty();
    private ConverterStrategy converter;
    private ObjectMapper mapper = new ObjectMapper();
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");

    private Cookies(HttpServletRequest request, HttpServletResponse response, ConverterStrategy converter) {
        this.request = request;
        this.response = response;
        this.converter = converter;
    }

    public static Cookies initFromServlet(HttpServletRequest request, HttpServletResponse response) {
        return new Cookies(request, response, null);
    }

    @Override
    public synchronized String get(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(lStrings.getString("err.cookie_name_blank"));
        }
        String cookieHeader = this.request.getHeader("cookie");
        if (cookieHeader == null) {
            return null;
        }
        Map<String, String> cookies = this.getCookies(cookieHeader);
        for (String decodedName : cookies.keySet()) {
            if (!name.equals(decodedName)) continue;
            return cookies.get(decodedName);
        }
        return null;
    }

    @Override
    public <T> T get(String name, Class<T> dataType) throws CookieParseException {
        String value = this.get(name);
        try {
            return (T)this.mapper.readValue(value, dataType);
        }
        catch (IOException e) {
            throw new CookieParseException(e);
        }
    }

    @Override
    public <T> T get(String name, TypeReference<T> typeRef) throws CookieParseException {
        String value = this.get(name);
        try {
            return (T)this.mapper.readValue(value, typeRef);
        }
        catch (IOException e) {
            throw new CookieParseException(e);
        }
    }

    @Override
    public Map<String, String> get() {
        HashMap<String, String> result = new HashMap<String, String>();
        String cookieHeader = this.request.getHeader("cookie");
        if (cookieHeader == null) {
            return result;
        }
        return this.getCookies(cookieHeader);
    }

    @Override
    public synchronized void set(String name, String value, AttributesDefinition attributes) {
        Boolean httpOnly;
        Boolean secure;
        String domain;
        Expiration expires;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(lStrings.getString("err.cookie_name_blank"));
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (attributes == null) {
            throw new IllegalArgumentException();
        }
        String encodedName = this.encode(name);
        String encodedValue = this.encodeValue(value);
        StringBuilder header = new StringBuilder();
        header.append(encodedName);
        header.append('=');
        header.append(encodedValue);
        attributes = this.extend(Attributes.empty().path("/"), this.defaults, attributes);
        String path = attributes.path();
        if (path != null && !path.isEmpty()) {
            header.append("; Path=" + path);
        }
        if ((expires = attributes.expires()) != null) {
            header.append("; Expires=" + expires.toExpiresString());
        }
        if ((domain = attributes.domain()) != null) {
            header.append("; Domain=" + domain);
        }
        if (Boolean.TRUE.equals(secure = attributes.secure())) {
            header.append("; Secure");
        }
        if (Boolean.TRUE.equals(httpOnly = attributes.httpOnly())) {
            header.append("; HttpOnly");
        }
        if (this.response.isCommitted()) {
            return;
        }
        this.setCookie(header.toString(), this.response);
    }

    @Override
    public void set(String name, int value, AttributesDefinition attributes) throws CookieSerializationException {
        this.set(name, String.valueOf(value), attributes);
    }

    @Override
    public void set(String name, boolean value, AttributesDefinition attributes) throws CookieSerializationException {
        this.set(name, String.valueOf(value), attributes);
    }

    @Override
    public <T> void set(String name, List<T> value, AttributesDefinition attributes) throws CookieSerializationException {
        try {
            this.set(name, this.mapper.writeValueAsString(value), attributes);
        }
        catch (JsonProcessingException e) {
            throw new CookieSerializationException(e);
        }
    }

    @Override
    public void set(String name, CookieValue value, AttributesDefinition attributes) throws CookieSerializationException {
        try {
            this.set(name, this.mapper.writeValueAsString((Object)value), attributes);
        }
        catch (JsonProcessingException e) {
            throw new CookieSerializationException(e);
        }
    }

    @Override
    public void set(String name, String value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(lStrings.getString("err.cookie_name_blank"));
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.set(name, value, this.defaults);
    }

    @Override
    public void set(String name, int value) throws CookieSerializationException {
        this.set(name, value, (AttributesDefinition)Attributes.empty());
    }

    @Override
    public void set(String name, boolean value) {
        this.set(name, String.valueOf(value));
    }

    @Override
    public <T> void set(String name, List<T> value) throws CookieSerializationException {
        this.set(name, value, (AttributesDefinition)Attributes.empty());
    }

    @Override
    public void set(String name, CookieValue value) throws CookieSerializationException {
        this.set(name, value, (AttributesDefinition)Attributes.empty());
    }

    @Override
    public void remove(String name, AttributesDefinition attributes) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(lStrings.getString("err.cookie_name_blank"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException();
        }
        this.set(name, "", (AttributesDefinition)this.extend(attributes, Attributes.empty().expires(Expiration.days(-1))));
    }

    @Override
    public void remove(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(lStrings.getString("err.cookie_name_blank"));
        }
        this.remove(name, Attributes.empty());
    }

    @Override
    public AttributesDefinition defaults() {
        return this.defaults;
    }

    @Override
    public Cookies withConverter(ConverterStrategy converter) {
        return new Cookies(this.request, this.response, converter);
    }

    private Attributes extend(AttributesDefinition ... mergeables) {
        Attributes result = Attributes.empty();
        for (AttributesDefinition mergeable : mergeables) {
            result.merge(mergeable);
        }
        return result;
    }

    private void setCookie(String cookieValue, HttpServletResponse response) {
        response.addHeader("Set-Cookie", cookieValue);
    }

    private String encode(String decoded) {
        return this.encode(decoded, new HashSet<Integer>());
    }

    private String encode(String decoded, Set<Integer> exceptions) {
        String encoded = decoded;
        int i = 0;
        while (i < decoded.length()) {
            boolean isAllowed;
            boolean isAsciiLowercaseLetter;
            boolean isAsciiUppercaseLetter;
            int codePoint = decoded.codePointAt(i);
            i += Character.charCount(codePoint);
            boolean isDigit = codePoint >= this.codePoint("0") && codePoint <= this.codePoint("9");
            if (isDigit || (isAsciiUppercaseLetter = codePoint >= this.codePoint("A") && codePoint <= this.codePoint("Z")) || (isAsciiLowercaseLetter = codePoint >= this.codePoint("a") && codePoint <= this.codePoint("z")) || (isAllowed = codePoint == this.codePoint("!") || codePoint == this.codePoint("#") || codePoint == this.codePoint("$") || codePoint == this.codePoint("&") || codePoint == this.codePoint("'") || codePoint == this.codePoint("*") || codePoint == this.codePoint("+") || codePoint == this.codePoint("-") || codePoint == this.codePoint(".") || codePoint == this.codePoint("^") || codePoint == this.codePoint("_") || codePoint == this.codePoint("`") || codePoint == this.codePoint("|") || codePoint == this.codePoint("~")) || exceptions.contains(codePoint)) continue;
            try {
                String character = new String(Character.toChars(codePoint));
                CharArrayWriter hexSequence = new CharArrayWriter();
                byte[] bytes = character.getBytes(UTF_8);
                for (int bytesIndex = 0; bytesIndex < bytes.length; ++bytesIndex) {
                    char left = Character.forDigit(bytes[bytesIndex] >> 4 & 0xF, 16);
                    char right = Character.forDigit(bytes[bytesIndex] & 0xF, 16);
                    hexSequence.append('%').append(left).append(right);
                }
                String target = character.toString();
                String sequence = hexSequence.toString().toUpperCase();
                encoded = encoded.replace(target, sequence);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return encoded;
    }

    private String decode(String encoded) {
        String decoded = encoded;
        Pattern pattern = Pattern.compile("(%[0-9A-Z]{2})+");
        Matcher matcher = pattern.matcher(encoded);
        while (matcher.find()) {
            String encodedChar = matcher.group();
            String[] encodedBytes = encodedChar.split("%");
            byte[] bytes = new byte[encodedBytes.length - 1];
            for (int i = 1; i < encodedBytes.length; ++i) {
                String encodedByte = encodedBytes[i];
                bytes[i - 1] = (byte)Integer.parseInt(encodedByte, 16);
            }
            try {
                String decodedChar = new String(bytes, UTF_8);
                decoded = decoded.replace(encodedChar, decodedChar);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return decoded;
    }

    private String encodeValue(String decodedValue) {
        HashSet<Integer> exceptions = new HashSet<Integer>();
        int i = 0;
        while (i < decodedValue.length()) {
            int codePoint = decodedValue.codePointAt(i);
            i += Character.charCount(codePoint);
            boolean isIgnorable = false;
            if (codePoint == this.codePoint("/") || codePoint == this.codePoint(":")) {
                isIgnorable = true;
            }
            if (codePoint >= this.codePoint("<") && codePoint <= this.codePoint("@")) {
                isIgnorable = true;
            }
            if (codePoint == this.codePoint("[") || codePoint == this.codePoint("]")) {
                isIgnorable = true;
            }
            if (codePoint == this.codePoint("{") || codePoint == this.codePoint("}")) {
                isIgnorable = true;
            }
            if (!isIgnorable) continue;
            exceptions.add(codePoint);
        }
        return this.encode(decodedValue, exceptions);
    }

    private int codePoint(String character) {
        return character.codePointAt(0);
    }

    private String decodeValue(String encodedValue, String decodedName) {
        String decodedValue = null;
        if (this.converter != null) {
            try {
                decodedValue = this.converter.convert(encodedValue, decodedName);
            }
            catch (ConverterException e) {
                e.printStackTrace();
            }
        }
        if (decodedValue == null) {
            decodedValue = this.decode(encodedValue);
        }
        return decodedValue;
    }

    private Map<String, String> getCookies(String cookieHeader) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] cookies = cookieHeader.split("; ");
        for (int i = 0; i < cookies.length; ++i) {
            String cookie = cookies[i];
            String encodedName = cookie.split("=")[0];
            String decodedName = this.decode(encodedName);
            String encodedValue = cookie.substring(cookie.indexOf(61) + 1, cookie.length());
            String decodedValue = this.decodeValue(encodedValue, decodedName);
            result.put(decodedName, decodedValue);
        }
        return result;
    }

    public static abstract class Converter
    implements ConverterStrategy {
    }

    public static class Attributes
    extends AttributesDefinition {
        private Expiration expires;
        private String path;
        private String domain;
        private Boolean secure;
        private Boolean httpOnly;

        private Attributes() {
        }

        public static Attributes empty() {
            return new Attributes();
        }

        @Override
        Expiration expires() {
            return this.expires;
        }

        @Override
        public Attributes expires(Expiration expires) {
            this.expires = expires;
            return this;
        }

        @Override
        String path() {
            return this.path;
        }

        @Override
        public Attributes path(String path) {
            this.path = path;
            return this;
        }

        @Override
        String domain() {
            return this.domain;
        }

        @Override
        public Attributes domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        Boolean secure() {
            return this.secure;
        }

        @Override
        public Attributes secure(Boolean secure) {
            this.secure = secure;
            return this;
        }

        @Override
        Boolean httpOnly() {
            return this.httpOnly;
        }

        @Override
        public Attributes httpOnly(Boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        private Attributes merge(AttributesDefinition reference) {
            if (reference.path() != null) {
                this.path = reference.path();
            }
            if (reference.domain() != null) {
                this.domain = reference.domain();
            }
            if (reference.expires() != null) {
                this.expires = reference.expires();
            }
            if (reference.secure() != null) {
                this.secure = reference.secure();
            }
            if (reference.httpOnly() != null) {
                this.httpOnly = reference.httpOnly();
            }
            return this;
        }
    }
}

