/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.github.jsonldjava.core.JsonLdApi;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.jena.JenaJSONLD;
import com.github.jsonldjava.jena.JenaRDFParser;
import com.github.jsonldjava.utils.JsonUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JSONLDToRDFTest {
    @BeforeClass
    public static void init() {
        JenaJSONLD.init();
    }

    @Test
    public void write() throws Exception {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://example.com/test");
        Property property = model.createProperty("http://example.com/value");
        model.add(resource, property, "Test");
        JsonLdOptions options = new JsonLdOptions();
        options.format = "application/ld+json";
        JenaRDFParser parser = new JenaRDFParser();
        RDFDataset dataset = parser.parse((Object)model);
        List json = new JsonLdApi(options).fromRDF(dataset);
        String jsonStr = JsonUtils.toPrettyString((Object)json);
        Assert.assertTrue((boolean)jsonStr.contains("@id"));
        Assert.assertTrue((boolean)jsonStr.contains("http://example.com/test"));
        Assert.assertTrue((boolean)jsonStr.contains("http://example.com/value"));
        Assert.assertTrue((boolean)jsonStr.contains("Test"));
    }
}

