/*
 * Decompiled with CFR 0.152.
 */
package com.github.kayjam.executor;

import com.github.kayjam.executor.exceptions.KayJamNotFoundException;
import com.github.kayjam.executor.exceptions.KayJamRuntimeException;
import com.github.kayjam.executor.executors.AccessExecutor;
import com.github.kayjam.executor.executors.CallCreateExecutor;
import com.github.kayjam.executor.executors.ClassContainerExecutor;
import com.github.kayjam.executor.executors.ConstExecutor;
import com.github.kayjam.executor.executors.ContainerExecutor;
import com.github.kayjam.executor.executors.IfExecutor;
import com.github.kayjam.executor.executors.ObjectExecutor;
import com.github.kayjam.executor.executors.OperationExpressionExecutor;
import com.github.kayjam.executor.executors.ReturnExecutor;
import com.github.kayjam.executor.executors.VariableExecutor;
import com.github.kayjam.executor.executors.VariableLinkExecutor;
import com.github.kayjam.executor.executors.VariableSetExecutor;
import com.github.kayjamlang.core.Expression;
import com.github.kayjamlang.core.containers.ClassContainer;
import com.github.kayjamlang.core.containers.Container;
import com.github.kayjamlang.core.containers.Function;
import com.github.kayjamlang.core.containers.ObjectContainer;
import com.github.kayjamlang.core.expressions.Access;
import com.github.kayjamlang.core.expressions.CallCreate;
import com.github.kayjamlang.core.expressions.Const;
import com.github.kayjamlang.core.expressions.If;
import com.github.kayjamlang.core.expressions.OperationExpression;
import com.github.kayjamlang.core.expressions.Return;
import com.github.kayjamlang.core.expressions.Variable;
import com.github.kayjamlang.core.expressions.VariableLink;
import com.github.kayjamlang.core.expressions.VariableSet;
import com.github.kayjamlang.core.provider.Context;
import com.github.kayjamlang.core.provider.MainContext;
import com.github.kayjamlang.core.provider.MainExpressionProvider;
import java.util.Map;

public class Executor
extends MainExpressionProvider<Object> {
    public Executor() {
        super(null);
        this.addCompiler(Container.class, new ContainerExecutor());
        this.addCompiler(ObjectContainer.class, new ObjectExecutor());
        this.addCompiler(ClassContainer.class, new ClassContainerExecutor());
        this.addCompiler(Variable.class, new VariableExecutor());
        this.addCompiler(VariableLink.class, new VariableLinkExecutor());
        this.addCompiler(VariableSet.class, new VariableSetExecutor());
        this.addCompiler(Access.class, new AccessExecutor());
        this.addCompiler(Const.class, new ConstExecutor());
        this.addCompiler(Return.class, new ReturnExecutor());
        this.addCompiler(If.class, new IfExecutor());
        this.addCompiler(CallCreate.class, new CallCreateExecutor());
        this.addCompiler(OperationExpression.class, new OperationExpressionExecutor());
    }

    public Object execute(Container container) throws Exception {
        ClassContainer classContainer;
        MainContext context = new MainContext(container, null);
        for (Expression expression : container.children) {
            if (!(expression instanceof ClassContainer)) continue;
            classContainer = (ClassContainer)expression;
            if (context.classes.containsKey(classContainer.name)) {
                throw new KayJamRuntimeException((Expression)classContainer, "A class with the same name has already been declared");
            }
            context.classes.put(classContainer.name, classContainer);
        }
        for (Map.Entry entry : context.classes.entrySet()) {
            classContainer = (ClassContainer)entry.getValue();
            for (String string : classContainer.implementsClass) {
                if (!context.classes.containsKey(string)) {
                    throw new KayJamNotFoundException((Expression)classContainer, "class interface", string);
                }
                ClassContainer implementsClass = (ClassContainer)context.classes.get(string);
                for (Function function : implementsClass.functions) {
                    Function fun = this.findFunction(classContainer, function);
                    if (fun.returnType.name.equals(function.returnType.name)) continue;
                    throw new KayJamRuntimeException((Expression)fun, "Invalid return type");
                }
                classContainer.children.addAll(implementsClass.children);
            }
        }
        return this.provide((Expression)container, (Context)context, (Context)context);
    }

    private Function findFunction(ClassContainer classContainer, Function function) throws KayJamRuntimeException {
        for (Function fun : classContainer.functions) {
            if (fun.arguments.size() != function.arguments.size() || !fun.name.equals(function.name)) continue;
            boolean args = true;
            for (int i = 0; i < fun.arguments.size(); ++i) {
                if (((Function.Argument)fun.arguments.get((int)i)).type.name.equals(((Function.Argument)function.arguments.get((int)i)).type.name)) continue;
                args = false;
                break;
            }
            if (!args) continue;
            return fun;
        }
        throw new KayJamRuntimeException((Expression)classContainer, "Function " + function.name + " not found from implements class");
    }
}

