/*
 * Decompiled with CFR 0.152.
 */
package com.github.krenfro.sendgrid.asm;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.krenfro.sendgrid.asm.SendGrid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;

public class GlobalSuppressionManager
extends SendGrid {
    public GlobalSuppressionManager(String username, String password) {
        super(username, password);
    }

    public List<String> add(String ... email) throws IOException {
        ArrayList<String> suppressions = new ArrayList<String>();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("recipient_emails", email);
        String payload = this.jackson.writeValueAsString(map);
        Request post = Request.Post((String)(this.baseUrl + "/suppressions/global")).addHeader("Accept", "application/json").addHeader("Authorization", this.authHeader);
        try {
            String json = post.bodyString(payload, ContentType.APPLICATION_JSON).execute().returnContent().asString();
            JsonNode array = this.jackson.readTree(json).path("recipient_emails");
            if (array.isArray()) {
                for (JsonNode entry : array) {
                    suppressions.add(entry.asText());
                }
            }
        }
        catch (HttpResponseException ex) {
            throw new IOException(ex);
        }
        return suppressions;
    }

    public boolean has(String email) throws IOException {
        Request get = Request.Get((String)(this.baseUrl + "/suppressions/global/" + email)).addHeader("Accept", "application/json").addHeader("Authorization", this.authHeader);
        try {
            String json = get.execute().returnContent().asString();
            return json.contains(email);
        }
        catch (HttpResponseException ex) {
            throw new IOException(ex);
        }
    }

    public void remove(String ... email) throws IOException {
        for (String entry : email) {
            Request delete = Request.Delete((String)(this.baseUrl + "/suppressions/global/" + entry)).addHeader("Accept", "application/json").addHeader("Authorization", this.authHeader);
            try {
                delete.execute();
            }
            catch (HttpResponseException ex) {
                throw new IOException(ex);
            }
        }
    }
}

