/*
 * Decompiled with CFR 0.152.
 */
package com.github.krenfro.sendgrid.asm;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.krenfro.sendgrid.asm.Group;
import com.github.krenfro.sendgrid.asm.SendGrid;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;

public class GroupManager
extends SendGrid {
    public GroupManager(String username, String password) {
        super(username, password);
        this.baseUrl = this.baseUrl.concat("/groups");
    }

    public Group retrieve(int id) throws IOException {
        Request get = Request.Get((String)this.baseUrl.concat("/" + id)).addHeader("Accept", "application/json").addHeader("Authorization", this.authHeader);
        try {
            String json = get.execute().returnContent().asString();
            return (Group)this.jackson.readValue(json, Group.class);
        }
        catch (HttpResponseException ex) {
            throw new IOException(ex);
        }
    }

    public Group add(String name, String description) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("description", description);
        String payload = this.jackson.writeValueAsString(map);
        Request post = Request.Post((String)this.baseUrl).addHeader("Accept", "application/json").addHeader("Authorization", this.authHeader);
        try {
            String json = post.bodyString(payload, ContentType.APPLICATION_JSON).execute().returnContent().asString();
            return (Group)this.jackson.readValue(json, Group.class);
        }
        catch (HttpResponseException ex) {
            throw new IOException(ex);
        }
    }

    public Group update(Group group) throws IOException {
        Objects.requireNonNull(group);
        if (group.getId() == null) {
            throw new IllegalArgumentException("Group has no id. Perhaps invoke create() instead of update()");
        }
        throw new UnsupportedOperationException("Update is not yet supported.  Need Apache HttpClient > 4.4+");
    }

    public boolean remove(Group group) throws IOException {
        Objects.requireNonNull(group);
        Request delete = Request.Delete((String)this.baseUrl.concat("/" + group.getId())).addHeader("Authorization", this.authHeader);
        try {
            HttpResponse response = delete.execute().returnResponse();
            return response.getStatusLine().getStatusCode() == 204;
        }
        catch (HttpResponseException ex) {
            throw new IOException(ex);
        }
    }

    public List<Group> retrieve() throws IOException {
        Request get = Request.Get((String)this.baseUrl).addHeader("Accept", "application/json").addHeader("Authorization", this.authHeader);
        try {
            String json = get.execute().returnContent().asString();
            TypeReference<List<Group>> typeRef = new TypeReference<List<Group>>(){};
            return (List)this.jackson.readValue(json, (TypeReference)typeRef);
        }
        catch (HttpResponseException ex) {
            throw new IOException(ex);
        }
    }
}

