/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.ConstNode;
import com.github.leeonky.dal.runtime.Calculator;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.util.Converter;
import java.math.BigDecimal;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AssertionFailure
extends DalException {
    public AssertionFailure(String message, int position) {
        super(message, position);
    }

    public static void assertListSize(int expected, int actual, int position) {
        if (expected != actual) {
            throw new AssertionFailure(String.format("expected list size [%d] but was [%d]", expected, actual), position);
        }
    }

    public static boolean assertMatchNull(Object actual, int position) {
        if (actual != null) {
            throw new AssertionFailure(String.format("[%s] does not match null", ConstNode.inspectValue(actual)), position);
        }
        return true;
    }

    public static boolean assertMatch(Object expect, Object actual, int position, Converter converter) {
        if (expect instanceof Number && actual instanceof Number && !expect.getClass().equals(actual.getClass())) {
            return AssertionFailure.assertMatch(new BigDecimal(expect.toString()), new BigDecimal(actual.toString()), position, converter);
        }
        if (!Calculator.equals(converter.convert(expect.getClass(), actual), expect)) {
            throw new AssertionFailure(String.format("expected [%s] matches [%s] but was not", ConstNode.inspectValue(actual), ConstNode.inspectValue(expect)), position);
        }
        return true;
    }

    public static void assertUnexpectedFields(Set<String> dataFields, int position) {
        if (!dataFields.isEmpty()) {
            throw new AssertionFailure("unexpected fields " + dataFields.stream().map(s -> String.format("`%s`", s)).collect(Collectors.joining(", ")), position);
        }
    }

    public static void assertUnexpectedFields(Set<String> dataFields, String element, int position) {
        if (!dataFields.isEmpty()) {
            throw new AssertionFailure(String.format("unexpected fields %s in %s", dataFields.stream().map(s -> String.format("`%s`", s)).collect(Collectors.joining(", ")), element), position);
        }
    }

    public static boolean assertEquals(Object actual, Object expected, int position) {
        if (!Calculator.equals(actual, expected)) {
            throw new AssertionFailure(String.format("expected [%s] equal to [%s] but was not", ConstNode.inspectValue(actual), ConstNode.inspectValue(expected)), position);
        }
        return true;
    }

    public static boolean assertRegexMatches(Pattern pattern, String actual, int position) {
        if (!pattern.matcher(actual).matches()) {
            throw new AssertionFailure(String.format("expected [%s] matches /%s/ but was not", ConstNode.inspectValue(actual), pattern), position);
        }
        return true;
    }
}

