/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.Expression;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.runtime.DataObject;
import com.github.leeonky.dal.runtime.RuntimeContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ListNode
extends Node {
    private final List<Expression> expressions;
    private final boolean incomplete;

    public ListNode(List<Expression> expressions) {
        long count = expressions.stream().filter(Objects::isNull).count();
        this.incomplete = count == 1L;
        this.expressions = expressions.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ListNode() {
        this(Collections.emptyList());
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public String inspect() {
        return String.format("[%s%s]", this.expressions.stream().map(Expression::getRightOperand).map(Node::inspect).collect(Collectors.joining(" ")), this.incomplete ? " ..." : "");
    }

    @Override
    public boolean judge(Node actualNode, Operator.Equal operator, RuntimeContext context) {
        DataObject dataObject = actualNode.evaluateDataObject(context);
        if (!dataObject.isList()) {
            throw new AssertionFailure(String.format("%s is not a list", actualNode.inspect()), this.getPositionBegin());
        }
        return this.judgeAll(context, dataObject);
    }

    @Override
    public boolean judge(Node actualNode, Operator.Matcher operator, RuntimeContext context) {
        DataObject dataObject = actualNode.evaluateDataObject(context);
        if (!dataObject.isList()) {
            throw new AssertionFailure(String.format("%s is not a list", actualNode.inspect()), this.getPositionBegin());
        }
        return this.judgeAll(context, dataObject);
    }

    private boolean judgeAll(RuntimeContext context, DataObject dataObject) {
        if (!this.incomplete) {
            AssertionFailure.assertListSize(this.expressions.size(), dataObject.getListSize(), this.getPositionBegin());
        }
        return context.newThisScope(dataObject, () -> this.expressions.stream().allMatch(expression -> (Boolean)expression.evaluate(context)));
    }
}

