/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.ast.RuntimeException;
import com.github.leeonky.dal.runtime.DataObject;
import com.github.leeonky.dal.runtime.RuntimeContext;
import com.github.leeonky.util.BeanClass;

public abstract class Node {
    private int positionBegin;

    public Object evaluate(RuntimeContext context) {
        throw new IllegalStateException();
    }

    public DataObject evaluateDataObject(RuntimeContext context) {
        return context.wrap(this.evaluate(context));
    }

    public boolean judge(Node actualNode, Operator.Equal operator, RuntimeContext context) {
        return AssertionFailure.assertEquals(actualNode.evaluate(context), this.evaluate(context), this.getPositionBegin());
    }

    public boolean judge(Node actualNode, Operator.Matcher operator, RuntimeContext context) {
        Object expect = this.evaluate(context);
        Object actual = actualNode.evaluate(context);
        if (expect == null) {
            return AssertionFailure.assertMatchNull(actual, actualNode.getPositionBegin());
        }
        this.shouldBeSameTypeIfTypeIs(Number.class, actual, expect, operator);
        this.shouldBeSameTypeIfTypeIs(Boolean.class, actual, expect, operator);
        this.invalidTypeToMatchStringValue(Number.class, actual, expect, operator);
        this.invalidTypeToMatchStringValue(Boolean.class, actual, expect, operator);
        return AssertionFailure.assertMatch(expect, actual, this.getPositionBegin(), context.getConverter());
    }

    public int getPositionBegin() {
        return this.positionBegin;
    }

    public Node setPositionBegin(int positionBegin) {
        this.positionBegin = positionBegin;
        return this;
    }

    public abstract String inspect();

    private void invalidTypeToMatchStringValue(Class<?> type, Object value1, Object value2, Operator.Matcher operator) {
        if (type.isInstance(value1) && value2 instanceof String) {
            throw new RuntimeException(String.format("Cannot matches between type '%s' and 'java.lang.String'", type.getName()), operator.getPosition());
        }
    }

    private void shouldBeSameTypeIfTypeIs(Class<?> type, Object value1, Object value2, Operator.Matcher operator) {
        if (type.isInstance(value2) && value1 != null && !type.isInstance(value1)) {
            throw new RuntimeException(String.format("Cannot matches between type '%s' and '%s'", BeanClass.getClassName((Object)value1), type.getName()), operator.getPosition());
        }
    }

    public Node avoidListMapping() {
        return this;
    }
}

