/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.Expression;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.ast.PropertyNode;
import com.github.leeonky.dal.runtime.DataObject;
import com.github.leeonky.dal.runtime.RuntimeContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ObjectNode
extends Node {
    private final List<Expression> expressions = new ArrayList<Expression>();

    public ObjectNode(List<Expression> expressions) {
        this.expressions.addAll(expressions);
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public ObjectNode() {
        this(Collections.emptyList());
    }

    @Override
    public String inspect() {
        return String.format("{%s}", this.expressions.stream().map(Expression::inspect).collect(Collectors.joining(" ")));
    }

    @Override
    public boolean judge(Node actualNode, Operator.Equal operator, RuntimeContext context) {
        DataObject dataObject = actualNode.evaluateDataObject(context);
        if (dataObject.isNull()) {
            throw new AssertionFailure(String.format("expected [null] equal to [%s] but was not", this.inspect()), this.getPositionBegin());
        }
        if (dataObject.isList()) {
            AtomicInteger integer = new AtomicInteger(0);
            dataObject.getListObjects().forEach(element -> AssertionFailure.assertUnexpectedFields(this.collectUnexpectedFields((DataObject)element), actualNode.inspect() + String.format("[%d]", integer.getAndIncrement()), operator.getPosition()));
        } else {
            AssertionFailure.assertUnexpectedFields(this.collectUnexpectedFields(dataObject), operator.getPosition());
        }
        return this.judgeAll(context, dataObject);
    }

    private Set<String> collectUnexpectedFields(DataObject dataObject) {
        LinkedHashSet<String> dataFields = new LinkedHashSet<String>(dataObject.getFieldNames());
        dataFields.removeAll(this.expressions.stream().map(expression -> dataObject.firstFieldFromAlias(((PropertyNode)expression.getLeftOperand()).getRootName())).collect(Collectors.toSet()));
        return dataFields;
    }

    @Override
    public boolean judge(Node actualNode, Operator.Matcher operator, RuntimeContext context) {
        DataObject dataObject = actualNode.evaluateDataObject(context);
        if (dataObject.isNull()) {
            throw new AssertionFailure(String.format("expected [null] matches [%s] but was not", this.inspect()), this.getPositionBegin());
        }
        return this.judgeAll(context, dataObject);
    }

    private boolean judgeAll(RuntimeContext context, DataObject dataObject) {
        return context.newThisScope(dataObject, () -> this.expressions.stream().allMatch(expression -> (Boolean)expression.evaluate(context)));
    }
}

