/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.ConstNode;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.ListNode;
import com.github.leeonky.dal.ast.ListTailNode;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.ObjectNode;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.ast.ParenthesesNode;
import com.github.leeonky.dal.ast.PropertyNode;
import com.github.leeonky.dal.ast.RegexNode;
import com.github.leeonky.dal.ast.SchemaExpression;
import com.github.leeonky.dal.ast.SchemaNode;
import com.github.leeonky.dal.ast.SchemaWhichExpression;
import com.github.leeonky.dal.ast.WildcardNode;
import com.github.leeonky.dal.compiler.EscapeChars;
import com.github.leeonky.dal.compiler.ExpressionFactory;
import com.github.leeonky.dal.compiler.ExpressionMatcher;
import com.github.leeonky.dal.compiler.NodeFactory;
import com.github.leeonky.dal.compiler.NodeMatcher;
import com.github.leeonky.dal.compiler.OperatorMatcher;
import com.github.leeonky.dal.compiler.SourceCode;
import com.github.leeonky.dal.compiler.TokenParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public class Compiler {
    private static final OperatorMatcher AND = TokenParser.operatorMatcher("&&", () -> new Operator.And("&&"));
    private static final OperatorMatcher OR = TokenParser.operatorMatcher("||", () -> new Operator.Or("||"));
    private static final OperatorMatcher AND_IN_KEY_WORD = TokenParser.operatorMatcher("and", () -> new Operator.And("and"));
    private static final OperatorMatcher COMMA_AND = TokenParser.operatorMatcher(",", () -> new Operator.And(","), TokenParser::isEnableCommaAnd);
    private static final OperatorMatcher OR_IN_KEY_WORD = TokenParser.operatorMatcher("or", () -> new Operator.Or("or"));
    private static final OperatorMatcher GREATER_OR_EQUAL = TokenParser.operatorMatcher(">=", Operator.GreaterOrEqual::new);
    private static final OperatorMatcher LESS_OR_EQUAL = TokenParser.operatorMatcher("<=", Operator.LessOrEqual::new);
    private static final OperatorMatcher GREATER = TokenParser.operatorMatcher(">", Operator.Greater::new);
    private static final OperatorMatcher LESS = TokenParser.operatorMatcher("<", Operator.Less::new);
    private static final OperatorMatcher PLUS = TokenParser.operatorMatcher("+", Operator.Plus::new);
    private static final OperatorMatcher SUBTRACTION = TokenParser.operatorMatcher("-", Operator.Subtraction::new);
    private static final OperatorMatcher MULTIPLICATION = TokenParser.operatorMatcher("*", Operator.Multiplication::new);
    private static final OperatorMatcher DIVISION = TokenParser.operatorMatcher("/", Operator.Division::new);
    private static final OperatorMatcher NOT_EQUAL = TokenParser.operatorMatcher("!=", Operator.NotEqual::new);
    private static final OperatorMatcher MINUS = TokenParser.operatorMatcher("-", Operator.Minus::new, tokenParser -> !tokenParser.getSourceCode().isBeginning());
    private static final OperatorMatcher NOT = TokenParser.operatorMatcher("!", Operator.Not::new, tokenParser -> !tokenParser.getSourceCode().startsWith("!="));
    private static final OperatorMatcher MATCHER = TokenParser.operatorMatcher(":", Operator.Matcher::new);
    private static final OperatorMatcher EQUAL = TokenParser.operatorMatcher("=", Operator.Equal::new);
    private static final OperatorMatcher BINARY_ARITHMETIC_OPERATORS = Compiler.oneOf(AND, OR, AND_IN_KEY_WORD, COMMA_AND, NOT_EQUAL, OR_IN_KEY_WORD, GREATER_OR_EQUAL, LESS_OR_EQUAL, GREATER, LESS, PLUS, SUBTRACTION, MULTIPLICATION, DIVISION);
    private static final OperatorMatcher UNARY_OPERATORS = Compiler.oneOf(MINUS, NOT);
    private static final OperatorMatcher JUDGEMENT_OPERATORS = Compiler.oneOf(MATCHER, EQUAL);
    private static final EscapeChars SINGLE_QUOTED_ESCAPES = new EscapeChars().escape("\\\\", '\\').escape("\\'", '\'');
    private static final EscapeChars DOUBLE_QUOTED_ESCAPES = new EscapeChars().escape("\\\\", '\\').escape("\\n", '\n').escape("\\t", '\t').escape("\\\"", '\"');
    private static final EscapeChars REGEX_ESCAPES = new EscapeChars().escape("\\/", '/');
    NodeMatcher INPUT = TokenParser::fetchInput;
    NodeMatcher NUMBER = TokenParser.NUMBER.map(token -> new ConstNode(token.getNumber()));
    NodeMatcher INTEGER = TokenParser.INTEGER.map(token -> new ConstNode(token.getInteger()));
    NodeMatcher SINGLE_QUOTED_STRING = parser -> parser.fetchString(Character.valueOf('\''), '\'', ConstNode::new, SINGLE_QUOTED_ESCAPES);
    NodeMatcher DOUBLE_QUOTED_STRING = parser -> parser.fetchString(Character.valueOf('\"'), '\"', ConstNode::new, DOUBLE_QUOTED_ESCAPES);
    NodeMatcher CONST_TRUE = parser -> parser.wordToken("true", token -> new ConstNode(true));
    NodeMatcher CONST_FALSE = parser -> parser.wordToken("false", token -> new ConstNode(false));
    NodeMatcher CONST_NULL = parser -> parser.wordToken("null", token -> new ConstNode(null));
    NodeMatcher REGEX = parser -> parser.fetchString(Character.valueOf('/'), '/', RegexNode::new, REGEX_ESCAPES);
    NodeMatcher IDENTITY_PROPERTY = TokenParser.IDENTITY_PROPERTY.map(token -> new PropertyNode(InputNode.INSTANCE, token.getContent(), PropertyNode.Type.IDENTIFIER));
    NodeMatcher WILDCARD = parser -> parser.wordToken("*", token -> new WildcardNode());
    NodeMatcher PROPERTY;
    NodeMatcher OBJECT;
    NodeMatcher LIST;
    NodeMatcher CONST;
    NodeMatcher PARENTHESES;
    NodeMatcher JUDGEMENT;
    NodeMatcher SCHEMA_WHICH_CLAUSE;
    NodeMatcher SCHEMA_JUDGEMENT_CLAUSE;
    NodeMatcher UNARY_OPERATOR_EXPRESSION;
    NodeFactory SCHEMA = TokenParser.SCHEMA.map(token -> new SchemaNode(token.getContent()));
    NodeFactory PROPERTY_CHAIN;
    NodeFactory OPERAND;
    NodeFactory EXPRESSION;
    NodeFactory LIST_INDEX_OR_MAP_KEY;
    NodeFactory ARITHMETIC_EXPRESSION;
    NodeFactory JUDGEMENT_EXPRESSION_OPERAND;
    ExpressionMatcher DOT_PROPERTY = (parser, previous) -> TokenParser.DOT_PROPERTY.map(token -> token.toDotProperty(previous)).fetch(parser);
    ExpressionMatcher BRACKET_PROPERTY;
    ExpressionMatcher EXPLICIT_PROPERTY;
    ExpressionMatcher BINARY_ARITHMETIC_EXPRESSION;
    ExpressionMatcher BINARY_JUDGEMENT_EXPRESSION;
    ExpressionMatcher BINARY_OPERATOR_EXPRESSION;
    ExpressionMatcher SCHEMA_EXPRESSION;

    public Compiler() {
        this.CONST = Compiler.oneOf(this.NUMBER, this.SINGLE_QUOTED_STRING, this.DOUBLE_QUOTED_STRING, this.CONST_TRUE, this.CONST_FALSE, this.CONST_NULL);
        this.LIST_INDEX_OR_MAP_KEY = Compiler.oneOf(this.INTEGER, this.SINGLE_QUOTED_STRING, this.DOUBLE_QUOTED_STRING).or("should given one property or array index in `[]`");
        this.PARENTHESES = parser -> parser.enableCommaAnd(() -> parser.fetchNode('(', ')', ParenthesesNode::new, this.EXPRESSION, "expect a value or expression"));
        this.BRACKET_PROPERTY = (parser, previous) -> parser.fetchNode('[', ']', node -> new PropertyNode(previous, ((ConstNode)node).getValue(), PropertyNode.Type.BRACKET), this.LIST_INDEX_OR_MAP_KEY, "should given one property or array index in `[]`");
        this.EXPLICIT_PROPERTY = Compiler.oneOf(this.DOT_PROPERTY, this.BRACKET_PROPERTY);
        this.PROPERTY = Compiler.oneOf(this.EXPLICIT_PROPERTY.defaultInputNode(), this.IDENTITY_PROPERTY);
        this.PROPERTY_CHAIN = parser -> this.PROPERTY.or("expect a object property").recursive(this.EXPLICIT_PROPERTY).fetch(parser);
        this.OBJECT = parser -> parser.disableCommaAnd(() -> parser.fetchNodes(Character.valueOf('{'), '}', ObjectNode::new, i -> parser.fetchExpression(this.PROPERTY_CHAIN.fetch(parser), JUDGEMENT_OPERATORS.or("expect operator `:` or `=`"), this.JUDGEMENT_EXPRESSION_OPERAND)));
        this.LIST = parser -> parser.disableCommaAnd(() -> parser.fetchNodes(Character.valueOf('['), ']', ListNode::new, i -> parser.wordToken("...", token -> new ListTailNode()).isPresent() ? null : parser.fetchExpression((Node)new PropertyNode(InputNode.INSTANCE, i, PropertyNode.Type.BRACKET), JUDGEMENT_OPERATORS.or(parser.DEFAULT_JUDGEMENT_OPERATOR), this.JUDGEMENT_EXPRESSION_OPERAND)));
        this.JUDGEMENT = Compiler.oneOf(this.REGEX, this.OBJECT, this.LIST, this.WILDCARD);
        this.UNARY_OPERATOR_EXPRESSION = parser -> parser.fetchExpression(null, UNARY_OPERATORS, this.OPERAND);
        this.OPERAND = this.UNARY_OPERATOR_EXPRESSION.or(Compiler.oneOf(this.CONST, this.PROPERTY, this.PARENTHESES, this.INPUT).or("expect a value or expression").recursive(this.EXPLICIT_PROPERTY).map(Node::avoidListMapping));
        this.BINARY_ARITHMETIC_EXPRESSION = (parser, previous) -> parser.fetchExpression(previous, BINARY_ARITHMETIC_OPERATORS, this.OPERAND);
        this.BINARY_JUDGEMENT_EXPRESSION = (parser, previous) -> parser.fetchExpression(previous, JUDGEMENT_OPERATORS, this.JUDGEMENT.or(this.OPERAND));
        this.BINARY_OPERATOR_EXPRESSION = Compiler.oneOf(this.BINARY_ARITHMETIC_EXPRESSION, this.BINARY_JUDGEMENT_EXPRESSION);
        this.ARITHMETIC_EXPRESSION = this.OPERAND.recursive(this.BINARY_ARITHMETIC_EXPRESSION);
        this.JUDGEMENT_EXPRESSION_OPERAND = this.JUDGEMENT.or(this.ARITHMETIC_EXPRESSION);
        this.SCHEMA_JUDGEMENT_CLAUSE = parser -> parser.fetchExpression((Node)InputNode.INSTANCE, JUDGEMENT_OPERATORS, this.JUDGEMENT_EXPRESSION_OPERAND);
        this.SCHEMA_WHICH_CLAUSE = parser -> parser.fetchNodeAfter("which", this.SCHEMA_JUDGEMENT_CLAUSE.or(this.EXPRESSION));
        this.SCHEMA_EXPRESSION = (parser, previous) -> parser.fetchNodeAfter("is", this.compileSchemaExpression(this.whichClause(this.SCHEMA_WHICH_CLAUSE, SchemaExpression::which), this.whichClause(this.SCHEMA_JUDGEMENT_CLAUSE, SchemaExpression::omitWhich)).toNode(previous));
        this.EXPRESSION = this.OPERAND.recursive(Compiler.oneOf(this.BINARY_OPERATOR_EXPRESSION, this.SCHEMA_EXPRESSION));
    }

    private ExpressionFactory compileSchemaExpression(Function<SchemaExpression, NodeMatcher> whichClause1, Function<SchemaExpression, NodeMatcher> whichClause2) {
        return (parser, previous) -> {
            SchemaExpression schemaExpression = new SchemaExpression(previous, parser.fetchNodes("/", this.SCHEMA));
            return Compiler.oneOf((NodeMatcher)whichClause1.apply(schemaExpression), (NodeMatcher)whichClause2.apply(schemaExpression)).fetch(parser).orElse(schemaExpression);
        };
    }

    private Function<SchemaExpression, NodeMatcher> whichClause(NodeMatcher clauseNodeMatcher, BiFunction<SchemaExpression, Node, SchemaWhichExpression> appendWay) {
        return schemaExpression -> clauseNodeMatcher.map(node -> (SchemaWhichExpression)appendWay.apply((SchemaExpression)schemaExpression, (Node)node));
    }

    public List<Node> compile(final SourceCode sourceCode) {
        return new ArrayList<Node>(){
            {
                TokenParser parser = new TokenParser(sourceCode);
                this.add(Compiler.this.EXPRESSION.fetch(parser));
                if (sourceCode.isBeginning() && sourceCode.isEndOfCode()) {
                    throw sourceCode.syntaxError("unexpected token", 0);
                }
                while (sourceCode.isEndOfCode()) {
                    this.add(Compiler.this.EXPRESSION.fetch(parser));
                }
            }
        };
    }

    public List<Object> toChainNodes(String sourceCode) {
        return ((PropertyNode)this.PROPERTY_CHAIN.fetch(new TokenParser(new SourceCode(sourceCode)))).getChain();
    }

    private static NodeMatcher oneOf(NodeMatcher matcher, NodeMatcher ... matchers) {
        return parser -> Stream.concat(Stream.of(matcher), Stream.of(matchers)).map(p -> p.fetch(parser)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private static ExpressionMatcher oneOf(ExpressionMatcher matcher, ExpressionMatcher ... matchers) {
        return (parser, previous) -> Stream.concat(Stream.of(matcher), Stream.of(matchers)).map(p -> p.fetch(parser, previous)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private static OperatorMatcher oneOf(OperatorMatcher matcher, OperatorMatcher ... matchers) {
        return parser -> Stream.concat(Stream.of(matcher), Stream.of(matchers)).map(p -> p.fetch(parser)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }
}

