/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.compiler.NodeFactory;
import com.github.leeonky.dal.compiler.TokenParser;
import java.util.Optional;
import java.util.function.Function;

public interface NodeMatcher {
    public Optional<Node> fetch(TokenParser var1);

    default public NodeMatcher map(Function<Node, Node> mapping) {
        return parser -> this.fetch(parser).map(mapping);
    }

    default public NodeFactory or(NodeFactory nodeFactory) {
        return parser -> this.fetch(parser).orElseGet(() -> nodeFactory.fetch(parser));
    }

    default public NodeFactory or(String message) {
        return parser -> this.fetch(parser).orElseThrow(() -> parser.getSourceCode().syntaxError(message, 0));
    }
}

