/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.Expression;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.compiler.Constants;
import com.github.leeonky.dal.compiler.NodeFactory;
import com.github.leeonky.dal.compiler.OperatorFactory;
import com.github.leeonky.dal.compiler.OperatorMatcher;
import com.github.leeonky.dal.compiler.SourceCode;
import com.github.leeonky.dal.compiler.Token;
import com.github.leeonky.dal.compiler.TokenFactory;
import com.github.leeonky.dal.compiler.TokenMatcher;
import com.github.leeonky.dal.runtime.FunctionUtil;
import com.github.leeonky.dal.runtime.IfThenFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TokenParser {
    public static final TokenMatcher NUMBER = SourceCode.tokenMatcher(Constants.DIGITAL::contains, Collections.emptyList(), false, (c1, c2) -> (c1.charValue() != 'e' && c1.charValue() != 'E' || c2.charValue() != '-' && c2.charValue() != '+') && Constants.DELIMITER.contains(c2), Token::isNumber);
    public static final TokenMatcher INTEGER = SourceCode.tokenMatcher(Constants.DIGITAL_OR_MINUS::contains, Collections.emptyList(), false, Constants.DELIMITER, Token::isNumber);
    public static final TokenMatcher IDENTITY_PROPERTY = SourceCode.tokenMatcher(FunctionUtil.not(Constants.DELIMITER::contains), Constants.ALL_KEY_WORDS, false, Constants.DELIMITER_OR_DOT, FunctionUtil.not(Token::isNumber));
    public static final TokenMatcher DOT_PROPERTY = SourceCode.tokenMatcher(Constants.DOT::equals, Collections.singletonList("..."), true, Constants.DELIMITER_OR_DOT, Token::all);
    public static final TokenFactory SCHEMA = SourceCode.tokenMatcher(FunctionUtil.not(Constants.DELIMITER::contains), Constants.ALL_KEY_WORDS, false, Constants.DELIMITER, FunctionUtil.not(Token::isNumber)).or("expect a schema");
    private final SourceCode sourceCode;
    private final LinkedList<Operator> operators = new LinkedList();
    private final LinkedList<Boolean> enableAndComma = new LinkedList<Boolean>(Collections.singleton(true));
    public final OperatorFactory DEFAULT_JUDGEMENT_OPERATOR = tokenParser -> this.operators.isEmpty() ? new Operator.Matcher() : this.operators.getFirst();

    public TokenParser(SourceCode sourceCode) {
        this.sourceCode = sourceCode;
    }

    public SourceCode getSourceCode() {
        return this.sourceCode;
    }

    public Optional<Node> fetchNode(char opening, char closing, Function<Node, Node> nodeFactory, NodeFactory nodeMatcher, String message) {
        return this.fetchNodes(Character.valueOf(opening), closing, args -> {
            if (args.size() != 1) {
                throw this.sourceCode.syntaxError(message, -1);
            }
            return (Node)nodeFactory.apply((Node)args.get(0));
        }, i -> nodeMatcher.fetch(this));
    }

    public <T extends Node> Optional<Node> fetchNodes(Character opening, char closing, Function<List<T>, Node> nodeFactory, Function<Integer, T> element) {
        return this.sourceCode.fetchElements(FetchBy.BY_NODE, opening, closing, element, nodeFactory);
    }

    public Optional<Node> fetchString(Character opening, char closing, Function<String, Node> nodeFactory, Map<String, Character> escapeChars) {
        return this.sourceCode.fetchElements(FetchBy.BY_CHAR, opening, closing, i -> Character.valueOf(this.sourceCode.escapedPop(escapeChars)), chars -> (Node)nodeFactory.apply(chars.stream().map(String::valueOf).collect(Collectors.joining())));
    }

    public Optional<Node> disableCommaAnd(Supplier<Optional<Node>> nodeFactory) {
        return this.commaAnd(false, nodeFactory);
    }

    public Optional<Node> enableCommaAnd(Supplier<Optional<Node>> nodeFactory) {
        return this.commaAnd(true, nodeFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Node> commaAnd(boolean b, Supplier<Optional<Node>> nodeFactory) {
        this.enableAndComma.push(b);
        try {
            Optional<Node> optional = nodeFactory.get();
            return optional;
        }
        finally {
            this.enableAndComma.pop();
        }
    }

    public Optional<Node> fetchInput() {
        return IfThenFactory.when(this.sourceCode.isBeginning()).optional(() -> InputNode.INSTANCE);
    }

    public <T extends Node> List<T> fetchNodes(final String delimiter, final NodeFactory factory) {
        return new ArrayList<T>(){
            {
                this.add(factory.fetch(TokenParser.this));
                while (TokenParser.this.sourceCode.popWord(delimiter).isPresent()) {
                    this.add(factory.fetch(TokenParser.this));
                }
            }
        };
    }

    public Optional<Node> fetchNodeAfter(String token, NodeFactory nodeFactory) {
        return this.sourceCode.popWord(token).map(t -> nodeFactory.fetch(this).setPositionBegin(t.getPosition()));
    }

    public Optional<Node> fetchExpression(Node left, OperatorMatcher operatorMatcher, NodeFactory rightCompiler) {
        return operatorMatcher.fetch(this).map(opt -> _ignore -> opt).map(operatorFactory -> this.fetchExpression(left, (OperatorFactory)operatorFactory, rightCompiler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression fetchExpression(Node left, OperatorFactory operatorFactory, NodeFactory rightCompiler) {
        Operator operator = operatorFactory.fetch(this);
        this.operators.push(operator);
        try {
            Expression expression = new Expression(left, operator, rightCompiler.fetch(this)).adjustOperatorOrder();
            return expression;
        }
        finally {
            this.operators.pop();
        }
    }

    public boolean isEnableCommaAnd() {
        return this.enableAndComma.getFirst();
    }

    public Optional<Node> wordToken(String word, Function<Token, Node> factory) {
        return this.sourceCode.popWord(word).map(t -> ((Node)factory.apply((Token)t)).setPositionBegin(t.getPosition()));
    }

    public static OperatorMatcher operatorMatcher(String symbol, Supplier<Operator> factory, Predicate<TokenParser> matcher) {
        return tokenParser -> tokenParser.getSourceCode().popWord(symbol, () -> matcher.test(tokenParser)).map(arg_0 -> TokenParser.lambda$null$13((Supplier)factory, arg_0));
    }

    public static OperatorMatcher operatorMatcher(String symbol, Supplier<Operator> factory) {
        return TokenParser.operatorMatcher(symbol, factory, s -> true);
    }

    private static /* synthetic */ Operator lambda$null$13(Supplier factory, Token token) {
        return ((Operator)factory.get()).setPosition(token.getPosition());
    }

    public static enum FetchBy {
        BY_CHAR,
        BY_NODE{

            @Override
            protected void afterFetchElement(SourceCode sourceCode) {
                sourceCode.popWord(",");
                sourceCode.leftTrim();
            }
        };


        protected void afterFetchElement(SourceCode tokenParser) {
        }
    }
}

