/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.format;

import java.util.Objects;

public interface Type<T> {
    public static <T> Type<T> equalTo(final T expect) {
        return new Type<T>(){

            @Override
            public boolean verify(T actual) {
                return Objects.equals(expect, actual);
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expect field `%s` [%s] to be equal to [%s], but was not.", field, actual, expect);
            }
        };
    }

    public static <T> Type<T> nullReference() {
        return new Type<T>(){

            @Override
            public boolean verify(T obj) {
                return Objects.isNull(obj);
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expect field `%s` [%s] to be null, but was not.", field, actual);
            }
        };
    }

    public static <T extends Comparable<T>> Type<T> lessThan(final T value) {
        return new Type<T>(){

            @Override
            public boolean verify(T actual) {
                return ((Comparable)Objects.requireNonNull(actual)).compareTo(value) < 0;
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expect field `%s` [%s] to be less than [%s], but was not.", field, actual, value);
            }
        };
    }

    public static <T extends Comparable<T>> Type<T> greaterThan(final T value) {
        return new Type<T>(){

            @Override
            public boolean verify(T actual) {
                return ((Comparable)Objects.requireNonNull(actual)).compareTo(value) > 0;
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expect field `%s` [%s] to be greater than [%s], but was not.", field, actual, value);
            }
        };
    }

    public static <T extends Comparable<T>> Type<T> lessOrEqualTo(final T value) {
        return new Type<T>(){

            @Override
            public boolean verify(T actual) {
                return ((Comparable)Objects.requireNonNull(actual)).compareTo(value) <= 0;
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expect field `%s` [%s] to be less or equal to [%s], but was not.", field, actual, value);
            }
        };
    }

    public static <T extends Comparable<T>> Type<T> greaterOrEqualTo(final T value) {
        return new Type<T>(){

            @Override
            public boolean verify(T actual) {
                return ((Comparable)Objects.requireNonNull(actual)).compareTo(value) >= 0;
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expect field `%s` [%s] to be greater or equal to [%s], but was not.", field, actual, value);
            }
        };
    }

    public boolean verify(T var1);

    public String errorMessage(String var1, Object var2);
}

