/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class FunctionUtil {
    public static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }

    @SafeVarargs
    public static <T> Optional<T> oneOf(Supplier<Optional<? extends T>> ... optionals) {
        return Stream.of(optionals).map(Supplier::get).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    @SafeVarargs
    public static <T> T getValue(final Supplier<? extends T> supplier, final Supplier<? extends T> ... suppliers) {
        return FunctionUtil.getValue(new ArrayList<Supplier<? extends T>>(){
            {
                this.add(supplier);
                this.addAll(Arrays.asList(suppliers));
            }
        });
    }

    private static <T> T getValue(List<Supplier<? extends T>> suppliers) {
        try {
            return suppliers.get(0).get();
        }
        catch (RuntimeException exception) {
            if (suppliers.size() > 1) {
                return FunctionUtil.getValue(suppliers.subList(1, suppliers.size()));
            }
            throw exception;
        }
    }
}

