/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.util.BeanUtil;
import com.github.leeonky.dal.util.PropertyAccessor;
import com.github.leeonky.dal.util.TypeData;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BeanWrapper {
    private final Object instance;
    private final Optional<PropertyAccessor> propertyAccessor;
    private final TypeData<PropertyAccessor> propertyAccessors;

    public BeanWrapper(Object instance, TypeData<PropertyAccessor> propertyAccessors) {
        this.instance = instance;
        this.propertyAccessor = propertyAccessors.getData(instance);
        this.propertyAccessors = propertyAccessors;
    }

    public Set<String> getPropertyNames() {
        return this.propertyAccessor.map(f -> f.getPropertyNames(this.instance)).orElseGet(() -> {
            if (this.instance instanceof Map) {
                return ((Map)this.instance).keySet();
            }
            return BeanUtil.findPropertyNames(this.instance.getClass());
        });
    }

    public Object getPropertyValue(String name) {
        return this.instance instanceof Map ? ((Map)this.instance).get(name) : this.getPropertyFromType(name);
    }

    public Object getInstance() {
        return this.instance;
    }

    public BeanWrapper getPropertyValueWrapper(String name) {
        return new BeanWrapper(this.getPropertyValue(name), this.propertyAccessors);
    }

    private Object getPropertyFromType(String name) {
        return this.propertyAccessor.map(p -> this.checkedReturn(() -> p.getValue(this.instance, name))).orElseGet(() -> this.checkedReturn(() -> BeanUtil.getPropertyValue(this.instance, name)));
    }

    private Object checkedReturn(CheckedSupplier supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static interface CheckedSupplier {
        public Object get() throws Exception;
    }
}

