/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.token;

import com.github.leeonky.dal.SyntaxException;
import com.github.leeonky.dal.token.SourceCode;
import com.github.leeonky.dal.token.Token;
import com.github.leeonky.dal.token.TokenCandidate;

class AccessElementTokenCandidate
extends TokenCandidate {
    AccessElementTokenCandidate(SourceCode sourceCode) {
        super(sourceCode);
    }

    @Override
    protected Token toToken() {
        if (!this.isFinished()) {
            throw new SyntaxException(this.getStartPosition() + this.content().length() + 1, "missed ']'");
        }
        try {
            return Token.constIndexToken(Integer.valueOf(this.content()));
        }
        catch (NumberFormatException ignore) {
            try {
                return Token.propertyToken(this.content());
            }
            catch (NumberFormatException e) {
                throw new SyntaxException(this.getStartPosition() + 1, "only support const int array index");
            }
        }
    }

    @Override
    protected String discardedSuffix() {
        return "]";
    }

    @Override
    protected boolean isDiscardBeginChar() {
        return true;
    }

    @Override
    protected boolean isUnexpectedChar(char c) {
        return false;
    }
}

