/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.token;

import com.github.leeonky.dal.token.SourceCode;
import com.github.leeonky.dal.token.Token;
import java.util.HashSet;
import java.util.Set;

public abstract class TokenCandidate {
    private final int startPosition;
    private final StringBuilder stringBuilder = new StringBuilder();
    private final Set<Character> split;
    private boolean finished = false;

    public TokenCandidate(SourceCode sourceCode) {
        this(sourceCode, new HashSet<Character>());
    }

    public TokenCandidate(SourceCode sourceCode, Set<Character> split) {
        this.split = split;
        this.startPosition = sourceCode.getPosition();
        char c = sourceCode.takeChar();
        if (!this.isDiscardBeginChar()) {
            this.stringBuilder.append(c);
        }
    }

    protected boolean append(char c) {
        this.stringBuilder.append(c);
        return false;
    }

    protected String content() {
        return this.stringBuilder.toString();
    }

    protected abstract Token toToken();

    protected boolean isDiscardBeginChar() {
        return false;
    }

    protected int getStartPosition() {
        return this.startPosition;
    }

    protected boolean isUnexpectedChar(char c) {
        return Character.isWhitespace(c) || c == '[' || this.split.contains(Character.valueOf(c));
    }

    Token getToken(SourceCode sourceCode) {
        while (sourceCode.notEnd() && !this.isDiscardedSuffix(sourceCode) && !this.isUnexpectedChar(sourceCode.getChar())) {
            while (this.append(sourceCode.takeChar()) && sourceCode.notEnd()) {
            }
        }
        return this.toToken();
    }

    protected String discardedSuffix() {
        return null;
    }

    protected boolean isFinished() {
        return this.finished;
    }

    private boolean isDiscardedSuffix(SourceCode sourceCode) {
        String suffix = this.discardedSuffix();
        if (suffix != null && sourceCode.startsWith(suffix)) {
            sourceCode.seek(suffix.length());
            this.finished = true;
            return true;
        }
        return false;
    }
}

