/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.util;

import com.github.leeonky.dal.util.BeanUtil;
import com.github.leeonky.dal.util.ListAccessor;
import com.github.leeonky.dal.util.PropertyAccessor;
import com.github.leeonky.dal.util.TypeData;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WrappedObject {
    private final Object instance;
    private final TypeData<PropertyAccessor> propertyAccessors;
    private final TypeData<ListAccessor> listAccessors;

    public WrappedObject(Object instance, TypeData<PropertyAccessor> propertyAccessors, TypeData<ListAccessor> listAccessors) {
        this.instance = instance;
        this.propertyAccessors = propertyAccessors;
        this.listAccessors = listAccessors;
    }

    public Set<String> getPropertyReaderNames() {
        return this.propertyAccessors.getData(this.instance).map(f -> f.getPropertyNames(this.instance)).orElseGet(() -> {
            if (this.instance instanceof Map) {
                return ((Map)this.instance).keySet();
            }
            return BeanUtil.findPropertyReaderNames(this.instance.getClass());
        });
    }

    public Object getPropertyValue(String name) {
        return this.instance instanceof Map ? ((Map)this.instance).get(name) : this.getPropertyFromType(name);
    }

    public Object getInstance() {
        return this.instance;
    }

    public WrappedObject getPropertyValueWrapper(String name) {
        return new WrappedObject(this.getPropertyValue(name), this.propertyAccessors, this.listAccessors);
    }

    public int getListSize() {
        int size = 0;
        for (Object dummy : this.getList()) {
            ++size;
        }
        return size;
    }

    public Iterable getList() {
        return this.listAccessors.getData(this.instance).map(l -> l.toIterable(this.instance)).orElseGet(() -> {
            if (this.instance instanceof Iterable) {
                return (Iterable)this.instance;
            }
            return () -> new Iterator(){
                private final int length;
                private int index;
                {
                    this.length = Array.getLength(WrappedObject.this.instance);
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.length;
                }

                public Object next() {
                    return Array.get(WrappedObject.this.instance, this.index++);
                }
            };
        });
    }

    public Iterable<WrappedObject> getWrappedList() {
        ArrayList<WrappedObject> result = new ArrayList<WrappedObject>();
        for (Object object : this.getList()) {
            result.add(new WrappedObject(object, this.propertyAccessors, this.listAccessors));
        }
        return result;
    }

    private Object getPropertyFromType(String name) {
        return this.propertyAccessors.getData(this.instance).map(p -> this.checkedReturn(() -> p.getValue(this.instance, name))).orElseGet(() -> this.checkedReturn(() -> BeanUtil.getPropertyValue(this.instance, name)));
    }

    private Object checkedReturn(CheckedSupplier supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static interface CheckedSupplier {
        public Object get() throws Exception;
    }
}

