/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.CompilingContextBuilder;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.util.ListAccessor;
import com.github.leeonky.dal.util.PropertyAccessor;
import com.github.leeonky.dal.util.TypeData;
import com.github.leeonky.dal.util.WrappedObject;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class CompilingContext {
    private final TypeData<PropertyAccessor> propertyAccessors;
    private final TypeData<ListAccessor> listAccessors;
    private final LinkedList<Object> wrappedValueStack = new LinkedList();
    private final Map<String, Function<Object, Object>> typeDefinitions;

    public CompilingContext(Object inputValue, TypeData<PropertyAccessor> propertyAccessors, Map<String, Function<Object, Object>> typeDefinitions, TypeData<ListAccessor> listAccessors) {
        this.propertyAccessors = propertyAccessors;
        this.listAccessors = listAccessors;
        this.wrappedValueStack.add(inputValue);
        this.typeDefinitions = typeDefinitions;
        typeDefinitions.put("List", o -> CompilingContextBuilder.requiredType(this.isList(o), () -> o));
    }

    public boolean isList(Object o) {
        return o != null && this.listAccessors.containsType(o) || o instanceof Iterable || o.getClass().isArray();
    }

    public Object getInputValue() {
        return this.wrappedValueStack.getLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object wrapInputValueAndEvaluate(Object value, Node node) {
        try {
            this.wrappedValueStack.add(value);
            Object object = node.evaluate(this);
            return object;
        }
        finally {
            this.wrappedValueStack.removeLast();
        }
    }

    public Optional<Function<Object, Object>> searchTypeDefinition(String type) {
        return Optional.ofNullable(this.typeDefinitions.get(type));
    }

    public Optional<ListAccessor> searchListAccessor(Object object) {
        return this.listAccessors.getData(object);
    }

    public WrappedObject wrap(Object instance) {
        return new WrappedObject(instance, this.propertyAccessors, this.listAccessors);
    }
}

