/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.CompilingContext;
import com.github.leeonky.dal.RuntimeException;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.TypeNode;
import com.github.leeonky.dal.token.IllegalTypeException;
import java.util.Objects;
import java.util.function.Function;

public class TypeAssertionExpression
extends Node {
    private final Node instance;
    private final TypeNode typeNode;
    private final Node assertion;

    public TypeAssertionExpression(Node instance, TypeNode typeNode, Node assertion) {
        this.instance = instance;
        this.typeNode = typeNode;
        this.assertion = assertion;
    }

    @Override
    public Object evaluate(CompilingContext context) {
        try {
            Object value = ((Function)this.typeNode.evaluate(context)).apply(this.instance.evaluate(context));
            return context.wrapInputValueAndEvaluate(value, this.assertion);
        }
        catch (IllegalTypeException ignore) {
            return false;
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e.getMessage(), this.typeNode.getPositionBegin());
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof TypeAssertionExpression && Objects.equals(this.instance, ((TypeAssertionExpression)obj).instance) && Objects.equals(this.typeNode, ((TypeAssertionExpression)obj).typeNode) && Objects.equals(this.assertion, ((TypeAssertionExpression)obj).assertion);
    }
}

