/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.Constructor;
import com.github.leeonky.dal.RuntimeContext;
import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.format.FormatterString;
import com.github.leeonky.dal.format.Instant;
import com.github.leeonky.dal.format.PositiveInteger;
import com.github.leeonky.dal.format.URL;
import com.github.leeonky.dal.token.IllegalTypeException;
import com.github.leeonky.dal.util.ListAccessor;
import com.github.leeonky.dal.util.PropertyAccessor;
import com.github.leeonky.dal.util.TypeData;
import com.github.leeonky.dal.util.WrappedObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RuntimeContextBuilder {
    private final TypeData<PropertyAccessor> propertyAccessors = new TypeData();
    private final TypeData<ListAccessor> listAccessors = new TypeData();
    private final Map<String, Constructor> constructors = new LinkedHashMap<String, Constructor>();
    private final Set<Class<?>> schemas = new HashSet();

    public RuntimeContextBuilder() {
        this.registerValueFormat(new PositiveInteger());
        this.registerValueFormat(new URL());
        this.registerValueFormat(new Instant());
        this.registerValueFormat(new FormatterString());
        this.registerSchema("List", WrappedObject::isList);
    }

    public RuntimeContext build(Object inputValue) {
        return new RuntimeContext(inputValue, this.propertyAccessors, this.constructors, this.listAccessors, this.schemas);
    }

    public RuntimeContextBuilder registerValueFormat(Formatter formatter) {
        return this.registerValueFormat(formatter.getFormatterName(), formatter);
    }

    public RuntimeContextBuilder registerValueFormat(String name, Formatter formatter) {
        this.constructors.put(name, (o, context) -> {
            if (formatter.isValidType(o)) {
                return formatter.toValue(o);
            }
            throw new IllegalTypeException();
        });
        return this;
    }

    public RuntimeContextBuilder registerSchema(Class<?> clazz) {
        return this.registerSchema(clazz.getSimpleName(), clazz);
    }

    public RuntimeContextBuilder registerSchema(String name, Class<?> clazz) {
        this.schemas.add(clazz);
        return this.registerSchema(name, (WrappedObject bw) -> bw.verifySchema(clazz, ""));
    }

    public RuntimeContextBuilder registerSchema(String name, Function<WrappedObject, Boolean> predicate) {
        this.constructors.put(name, (o, context) -> {
            if (o != null && ((Boolean)predicate.apply(context.wrap(o))).booleanValue()) {
                return o;
            }
            throw new IllegalTypeException();
        });
        return this;
    }

    public <T> RuntimeContextBuilder registerPropertyAccessor(Class<T> type, PropertyAccessor<T> propertyAccessor) {
        this.propertyAccessors.put(type, propertyAccessor);
        return this;
    }

    public <T> RuntimeContextBuilder registerListAccessor(Class<T> type, ListAccessor<T> listAccessor) {
        this.listAccessors.put(type, listAccessor);
        return this;
    }
}

