/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.RuntimeContext;
import com.github.leeonky.dal.RuntimeException;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.Operator;
import java.util.Objects;

public class Expression
extends Node {
    private final Node node1;
    private final Operator operator;
    private final Node node2;

    public Expression(Node node1, Operator operator, Node node2) {
        this.node1 = node1;
        this.node2 = node2;
        this.operator = operator;
    }

    public Expression adjustOperatorOrder() {
        if (this.node1 instanceof Expression) {
            Expression expression1 = (Expression)this.node1;
            if (this.operator.isPrecedentThan(expression1.operator)) {
                return new Expression(expression1.node1, expression1.operator, new Expression(expression1.node2, this.operator, this.node2).adjustOperatorOrder());
            }
        }
        return this;
    }

    @Override
    public Object evaluate(RuntimeContext context) {
        try {
            return this.operator.calculate(this.node1, this.node2, context);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex.getMessage(), this.operator.getPosition());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RuntimeException("Array index out of range", this.operator.getPosition());
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof Expression && Objects.equals(this.node1, ((Expression)obj).node1) && Objects.equals(this.node2, ((Expression)obj).node2) && Objects.equals(this.operator, ((Expression)obj).operator) && Objects.equals(this.operator, ((Expression)obj).operator);
    }
}

