/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.token;

import com.github.leeonky.dal.token.AccessElementTokenCandidateFactory;
import com.github.leeonky.dal.token.BeginBracketTokenCandidateFactory;
import com.github.leeonky.dal.token.DoubleQuotationStringTokenCandidateFactory;
import com.github.leeonky.dal.token.EndBracketTokenCandidateFactory;
import com.github.leeonky.dal.token.NumberTokenCandidateFactory;
import com.github.leeonky.dal.token.OperatorTokenCandidateFactory;
import com.github.leeonky.dal.token.PropertyTokenCandidateFactory;
import com.github.leeonky.dal.token.SingleQuotationStringTokenCandidateFactory;
import com.github.leeonky.dal.token.SourceCode;
import com.github.leeonky.dal.token.Token;
import com.github.leeonky.dal.token.TokenCandidate;
import com.github.leeonky.dal.token.TokenCandidateFactory;
import com.github.leeonky.dal.token.TokenStream;
import com.github.leeonky.dal.token.WordTokenCandidate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Scanner {
    public static final Set<Character> CHAR_SPLIT = new HashSet<Character>(Arrays.asList(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('<'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('!')));
    public static final List<String> MULTI_CHAR_OPTS = Arrays.asList(">=", "<=", "&&", "||", "!=");
    public static final Set<String> KEYWORD_SETS = new HashSet<String>(Arrays.asList("is", "which"));
    private List<TokenCandidateFactory> factories = Arrays.asList(NumberTokenCandidateFactory.INSTANCE, PropertyTokenCandidateFactory.INSTANCE, AccessElementTokenCandidateFactory.INSTANCE, OperatorTokenCandidateFactory.INSTANCE, BeginBracketTokenCandidateFactory.INSTANCE, EndBracketTokenCandidateFactory.INSTANCE, SingleQuotationStringTokenCandidateFactory.INSTANCE, DoubleQuotationStringTokenCandidateFactory.INSTANCE);

    public TokenStream scan(SourceCode sourceCode) {
        TokenStream tokenStream = new TokenStream();
        while (sourceCode.hasContent()) {
            int begin = sourceCode.getPosition();
            Token token = this.takeTokenCandidate(sourceCode).getToken(sourceCode);
            token.setPositionBegin(begin);
            token.setPositionEnd(sourceCode.getPosition());
            tokenStream.appendToken(token);
        }
        return tokenStream;
    }

    private TokenCandidate takeTokenCandidate(SourceCode sourceCode) {
        return this.factories.stream().filter(f -> f.isBegin(sourceCode)).map(f -> f.createTokenCandidate(sourceCode)).findFirst().orElseGet(() -> new WordTokenCandidate(sourceCode));
    }
}

