/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.RuntimeContext;
import com.github.leeonky.dal.RuntimeException;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.util.WrappedObject;
import java.util.List;
import java.util.Objects;

public class PropertyNode
extends Node {
    private final Node instanceNode;
    private final List<String> properties;

    public PropertyNode(Node instanceNode, List<String> properties) {
        this.instanceNode = instanceNode;
        this.properties = properties;
    }

    @Override
    public Object evaluate(RuntimeContext context) {
        Object instance = this.instanceNode.evaluate(context);
        for (String name : this.properties) {
            instance = this.getPropertyValue(instance, name, context);
        }
        return instance;
    }

    private Object getPropertyValue(Object instance, String name, RuntimeContext context) {
        WrappedObject wrappedObject = context.wrap(instance);
        if ("size".equals(name) && wrappedObject.isList()) {
            return wrappedObject.getListSize();
        }
        try {
            return wrappedObject.getPropertyValue(name);
        }
        catch (Exception e) {
            throw new RuntimeException("Get property '" + name + "' failed, property can be public field, getter or customer type getter", this.getPositionBegin());
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof PropertyNode && Objects.equals(this.instanceNode, ((PropertyNode)obj).instanceNode) && Objects.equals(this.properties, ((PropertyNode)obj).properties);
    }
}

