/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.util;

import com.github.leeonky.dal.RuntimeContext;
import com.github.leeonky.dal.util.SchemaVerifier;
import com.github.leeonky.util.BeanClass;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WrappedObject {
    private final RuntimeContext runtimeContext;
    private final Object instance;
    private final BeanClass<Object> beanClass;

    public WrappedObject(Object instance, RuntimeContext context) {
        this.instance = instance;
        this.beanClass = instance == null ? null : BeanClass.create(instance.getClass());
        this.runtimeContext = context;
    }

    public Object getInstance() {
        return this.instance;
    }

    public boolean isList() {
        return this.instance != null && (this.runtimeContext.isRegisteredList(this.instance) || this.instance instanceof Iterable || this.instance.getClass().isArray());
    }

    public Set<String> getPropertyReaderNames() {
        return this.runtimeContext.findPropertyReaderNames(this.instance).orElseGet(() -> {
            if (this.instance instanceof Map) {
                return ((Map)this.instance).keySet();
            }
            return this.beanClass.getPropertyReaders().keySet();
        });
    }

    public Object getPropertyValue(String name) {
        if (name.contains(".")) {
            String[] split = name.split("\\.", 2);
            return this.getWrappedPropertyValue(split[0]).getPropertyValue(split[1]);
        }
        return this.instance instanceof Map ? ((Map)this.instance).get(name) : this.getPropertyFromType(name);
    }

    public WrappedObject getWrappedPropertyValue(String name) {
        return this.runtimeContext.wrap(this.getPropertyValue(name));
    }

    public int getListSize() {
        int size = 0;
        for (Object ignore : this.getList()) {
            ++size;
        }
        return size;
    }

    public Iterable getList() {
        return this.runtimeContext.gitList(this.instance).orElseGet(() -> {
            if (this.instance instanceof Iterable) {
                return (Iterable)this.instance;
            }
            return () -> new Iterator(){
                private final int length;
                private int index;
                {
                    this.length = Array.getLength(WrappedObject.this.instance);
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.length;
                }

                public Object next() {
                    return Array.get(WrappedObject.this.instance, this.index++);
                }
            };
        });
    }

    public Iterable<WrappedObject> getWrappedList() {
        ArrayList<WrappedObject> result = new ArrayList<WrappedObject>();
        for (Object object : this.getList()) {
            result.add(this.runtimeContext.wrap(object));
        }
        return result;
    }

    private Object getPropertyFromType(String name) {
        return this.runtimeContext.getPropertyValue(this.instance, name).orElseGet(() -> this.beanClass.getPropertyValue(this.instance, name));
    }

    public boolean isNull() {
        return this.runtimeContext.isNull(this.instance);
    }

    public SchemaVerifier createSchemaVerifier() {
        return new SchemaVerifier(this.runtimeContext, this);
    }
}

