/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.ListEllipsisNode;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.ast.PropertyNode;
import com.github.leeonky.dal.ast.RuntimeException;
import com.github.leeonky.dal.compiler.ExpressionClause;
import com.github.leeonky.dal.compiler.SyntaxException;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ElementAssertionFailure;
import com.github.leeonky.dal.runtime.FunctionUtil;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListNode
extends Node {
    private List<Node> expressions__;
    private List<Node> inputExpressions;
    private List<ExpressionClause> expressionFactories;
    private final Type type;
    private final boolean multiLineList;

    public ListNode(List<ExpressionClause> expressionFactories, boolean multiLineList) {
        this.type = this.guessType(expressionFactories);
        this.expressionFactories = expressionFactories;
        this.multiLineList = multiLineList;
        this.getExpressions(0);
    }

    private List<Node> getExpressions(int firstIndex) {
        return this.expressions__ != null ? this.expressions__ : this.type.checkElements(this.getInputExpressions(firstIndex)).stream().filter(node -> !(node instanceof ListEllipsisNode)).collect(Collectors.toList());
    }

    private List<Node> getInputExpressions(int firstIndex) {
        return this.inputExpressions != null ? this.inputExpressions : FunctionUtil.mapWithIndex(this.expressionFactories.stream(), (i, clause) -> clause.makeExpression(new PropertyNode(InputNode.INSTANCE, this.type.indexOfNode(firstIndex, (int)i, this.expressionFactories.size()), PropertyNode.Type.BRACKET))).collect(Collectors.toList());
    }

    public ListNode(List<Node> inputExpressions, boolean multiLineList, Type type) {
        this.inputExpressions = new ArrayList<Node>(inputExpressions);
        this.expressions__ = this.inputExpressions;
        this.multiLineList = multiLineList;
        this.type = type;
    }

    public ListNode(List<ExpressionClause> expressionFactories) {
        this(expressionFactories, false);
    }

    private Type guessType(List<ExpressionClause> expressionFactories) {
        if (expressionFactories.size() > 0 && expressionFactories.get(expressionFactories.size() - 1).isListEllipsis()) {
            return Type.FIRST_N_ITEMS;
        }
        if (expressionFactories.size() > 0 && expressionFactories.get(0).isListEllipsis()) {
            return Type.LAST_N_ITEMS;
        }
        return Type.ALL_ITEMS;
    }

    public ListNode() {
        this(Collections.emptyList());
    }

    public List<Node> getExpressions() {
        return this.getExpressions(0);
    }

    @Override
    public String inspect() {
        return this.getInputExpressions(0).stream().map(Node::inspectClause).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public boolean judge(Node actualNode, Operator.Equal operator, RuntimeContextBuilder.RuntimeContext context) {
        return this.judgeAll(context, actualNode.evaluateDataObject(context));
    }

    @Override
    public boolean judge(Node actualNode, Operator.Matcher operator, RuntimeContextBuilder.RuntimeContext context) {
        return this.judgeAll(context, actualNode.evaluateDataObject(context));
    }

    public boolean judgeAll(RuntimeContextBuilder.RuntimeContext context, Data data) {
        if (!data.isList()) {
            throw new RuntimeException(String.format("Cannot compare%sand list", data.inspect()), this.getPositionBegin());
        }
        List<Node> expressions = this.getExpressions(data.getListFirstIndex());
        if (this.type == Type.ALL_ITEMS) {
            AssertionFailure.assertListSize(expressions.size(), data.getListSize(), this.getPositionBegin());
        }
        return context.newThisScope(data, () -> this.assertElementExpressions(context, expressions));
    }

    private boolean assertElementExpressions(RuntimeContextBuilder.RuntimeContext context, List<Node> expressions) {
        if (this.multiLineList) {
            FunctionUtil.eachWithIndex(expressions.stream(), (i, expression) -> {
                try {
                    expression.evaluate(context);
                }
                catch (DalException dalException) {
                    throw new ElementAssertionFailure(expressions, (int)i, dalException);
                }
            });
        } else {
            expressions.forEach(expression -> expression.evaluate(context));
        }
        return true;
    }

    public static enum Type {
        ALL_ITEMS{

            @Override
            protected Stream<Node> toChecking(List<Node> inputExpressions) {
                return inputExpressions.stream();
            }
        }
        ,
        FIRST_N_ITEMS{

            @Override
            protected Stream<Node> toChecking(List<Node> inputExpressions) {
                return inputExpressions.stream().limit(inputExpressions.size() - 1);
            }
        }
        ,
        LAST_N_ITEMS{

            @Override
            int indexOfNode(int firstIndex, int index, int count) {
                return index - count;
            }

            @Override
            protected Stream<Node> toChecking(List<Node> inputExpressions) {
                return inputExpressions.stream().skip(1L);
            }
        };


        int indexOfNode(int firstIndex, int index, int count) {
            return index + firstIndex;
        }

        protected abstract Stream<Node> toChecking(List<Node> var1);

        public List<Node> checkElements(List<Node> inputExpressions) {
            this.toChecking(inputExpressions).forEach(node -> {
                if (node instanceof ListEllipsisNode) {
                    throw new SyntaxException("unexpected token", node.getPositionBegin());
                }
            });
            return inputExpressions;
        }
    }
}

