/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.ast.RuntimeException;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;

public abstract class Node {
    private int positionBegin;

    public Object evaluate(RuntimeContextBuilder.RuntimeContext context) {
        throw new IllegalStateException();
    }

    public Data evaluateDataObject(RuntimeContextBuilder.RuntimeContext context) {
        return context.wrap(this.evaluate(context));
    }

    public boolean judge(Node actualNode, Operator.Equal operator, RuntimeContextBuilder.RuntimeContext context) {
        return AssertionFailure.assertEquals(this.evaluateDataObject(context), this.evaluateAndWrapperFailureMessage(actualNode, context), this.getPositionBegin());
    }

    public boolean judge(Node actualNode, Operator.Matcher operator, RuntimeContextBuilder.RuntimeContext context) {
        Data expected = this.evaluateDataObject(context);
        Data actual = this.evaluateAndWrapperFailureMessage(actualNode, context);
        if (expected.isNull()) {
            return AssertionFailure.assertMatchNull(actual, actualNode.getPositionBegin());
        }
        this.shouldBeSameTypeIfTypeIs(Number.class, actual, operator, expected);
        this.shouldBeSameTypeIfTypeIs(Boolean.class, actual, operator, expected);
        this.invalidTypeToMatchStringValue(Number.class, actual, expected, operator);
        this.invalidTypeToMatchStringValue(Boolean.class, actual, expected, operator);
        return AssertionFailure.assertMatch(expected, actual, this.getPositionBegin(), context.getConverter());
    }

    private Data evaluateAndWrapperFailureMessage(Node actualNode, RuntimeContextBuilder.RuntimeContext context) {
        try {
            return actualNode.evaluateDataObject(context);
        }
        catch (AssertionFailure assertionFailure) {
            throw assertionFailure.multiPosition(this.getPositionBegin(), DalException.Position.Type.CHAR);
        }
    }

    public int getPositionBegin() {
        return this.positionBegin;
    }

    public Node setPositionBegin(int positionBegin) {
        this.positionBegin = positionBegin;
        return this;
    }

    public abstract String inspect();

    private void invalidTypeToMatchStringValue(Class<?> type, Data actual, Data expected, Operator.Matcher operator) {
        if (type.isInstance(actual.getInstance()) && expected.getInstance() instanceof String) {
            throw new RuntimeException(String.format("Cannot compare between%sand 'java.lang.String'", actual.inspect()), operator.getPosition());
        }
    }

    private void shouldBeSameTypeIfTypeIs(Class<?> type, Data value1, Operator.Matcher operator, Data value2) {
        if (type.isInstance(value2.getInstance()) && !value1.isNull() && !type.isInstance(value1.getInstance())) {
            throw new RuntimeException(String.format("Cannot compare between%sand%s", value1.inspect(), value2.inspect()), operator.getPosition());
        }
    }

    public Node avoidListMapping() {
        return this;
    }

    public Object getRootName() {
        return null;
    }

    public String inspectClause() {
        return this.inspect();
    }

    public int getOperandPosition() {
        return this.positionBegin;
    }
}

