/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.RuntimeException;
import com.github.leeonky.dal.ast.SchemaExpression;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;

public class SchemaWhichExpression
extends Node {
    private final SchemaExpression schemaExpression;
    private final Node clause;
    private final boolean omitWhich;

    public SchemaWhichExpression(SchemaExpression schemaExpression, Node clause, boolean omitWhich) {
        this.schemaExpression = schemaExpression;
        this.clause = clause;
        this.omitWhich = omitWhich;
    }

    @Override
    public String inspect() {
        return this.schemaExpression.inspect() + " " + (this.omitWhich ? "" : "which ") + this.clause.inspect();
    }

    @Override
    public Object evaluate(RuntimeContextBuilder.RuntimeContext context) {
        try {
            return context.newThisScope(this.schemaExpression.evaluateDataObject(context), () -> this.clause.evaluate(context));
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e.getMessage(), this.getPositionBegin());
        }
    }
}

