/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.HeaderNode;
import com.github.leeonky.dal.ast.ListNode;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.ast.RowNode;
import com.github.leeonky.dal.ast.SequenceNode;
import com.github.leeonky.dal.compiler.ExpressionClause;
import com.github.leeonky.dal.compiler.SyntaxException;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.dal.runtime.ElementAssertionFailure;
import com.github.leeonky.dal.runtime.FunctionUtil;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TableNode
extends Node {
    private final List<HeaderNode> headers;
    private final List<RowNode> rows;
    private final Type type;
    private final boolean hasRowIndex;

    public TableNode(List<HeaderNode> headers, List<RowNode> row) {
        this(headers, row, Type.NORMAL);
    }

    public TableNode(List<HeaderNode> headers, List<RowNode> rows, Type type) {
        this.headers = new ArrayList<HeaderNode>(headers);
        this.rows = new ArrayList<RowNode>(rows);
        this.type = type;
        this.hasRowIndex = !rows.isEmpty() && rows.get(0).hasIndex();
        this.checkRowIndex(rows);
    }

    private void checkRowIndex(List<RowNode> rows) {
        rows.stream().skip(1L).filter(rowNode -> this.hasRowIndex ^ rowNode.hasIndex()).findAny().ifPresent(row -> this.type.raiseInvalidRowIndex((RowNode)rows.get(0), (RowNode)row));
    }

    public List<HeaderNode> getHeaders() {
        return this.headers;
    }

    public List<RowNode> getRows() {
        return this.rows;
    }

    @Override
    public String inspect() {
        return this.type.inspect(this.headers, this.rows);
    }

    @Override
    public boolean judge(Node actualNode, Operator.Equal operator, RuntimeContextBuilder.RuntimeContext context) {
        return this.judgeRows(actualNode, operator, context);
    }

    @Override
    public boolean judge(Node actualNode, Operator.Matcher operator, RuntimeContextBuilder.RuntimeContext context) {
        return this.judgeRows(actualNode, operator, context);
    }

    private boolean judgeRows(Node actualNode, Operator operator, RuntimeContextBuilder.RuntimeContext context) {
        try {
            return this.transformToListNode(operator).judgeAll(context, actualNode.evaluateDataObject(context).setListComparator(this.collectComparator(context)));
        }
        catch (ElementAssertionFailure elementAssertionFailure) {
            throw this.type.toDalException(elementAssertionFailure, this);
        }
    }

    private ListNode transformToListNode(Operator operator) {
        Stream<ExpressionClause> rowExpressionClauses = this.rows.stream().map(rowNode -> rowNode.toExpressionClause(operator));
        return this.hasRowIndex ? new ListNode(rowExpressionClauses.map(rowNode -> rowNode.makeExpression(null)).collect(Collectors.toList()), true, ListNode.Type.FIRST_N_ITEMS) : new ListNode(rowExpressionClauses.collect(Collectors.toList()), true);
    }

    private Comparator<Object> collectComparator(RuntimeContextBuilder.RuntimeContext context) {
        return this.headers.stream().sorted(HeaderNode.bySequence()).map(headerNode -> headerNode.getListComparator(context)).reduce(Comparator::thenComparing).orElse(SequenceNode.NOP_COMPARATOR);
    }

    public static enum Type {
        NORMAL,
        TRANSPOSED{

            @Override
            public DalException toDalException(ElementAssertionFailure elementAssertionFailure, TableNode tableNode) {
                return elementAssertionFailure.columnPositionException(tableNode);
            }

            @Override
            public String inspect(List<HeaderNode> headers, List<RowNode> rows) {
                String tableContent = FunctionUtil.zip(headers.stream().map(HeaderNode::inspect).collect(Collectors.toList()).stream(), this.inspectCells(rows, headers.size()).stream(), this::mergeHeaderAndCells).map(RowNode::printTableRow).collect(Collectors.joining("\n"));
                return rows.stream().anyMatch(RowNode::hasSchemaOrOperator) ? String.format("| >> %s\n%s", RowNode.printTableRow(rows.stream().map(rowNode -> rowNode.inspectSchemaAndOperator().trim())), tableContent) : ">>" + tableContent;
            }

            @Override
            public void raiseInvalidRowIndex(final RowNode firstRow, final RowNode invalidRow) {
                throw new SyntaxException("Row index should be consistent", firstRow.getCells().get(0).getPositionBegin(), DalException.Position.Type.CHAR){
                    {
                        super(message, position, type);
                        firstRow.getCells().stream().skip(1L).forEach(cell -> this.multiPosition(cell.getPositionBegin(), DalException.Position.Type.CHAR));
                        invalidRow.getCells().forEach(cell -> this.multiPosition(cell.getPositionBegin(), DalException.Position.Type.CHAR));
                    }
                };
            }

            private ArrayList<String> mergeHeaderAndCells(final String h, final List<String> cells) {
                return new ArrayList<String>(){
                    {
                        this.add(h);
                        this.addAll(cells);
                    }
                };
            }

            private List<List<String>> inspectCells(List<RowNode> rows, int headerCount) {
                List<List<String>> rowCells = FunctionUtil.transpose(rows.stream().map(RowNode::inspectCells).collect(Collectors.toList()));
                return rowCells.isEmpty() ? Collections.nCopies(headerCount, Collections.emptyList()) : rowCells;
            }
        };


        public DalException toDalException(ElementAssertionFailure elementAssertionFailure, TableNode tableNode) {
            return elementAssertionFailure.linePositionException();
        }

        public String inspect(final List<HeaderNode> headers, final List<RowNode> rows) {
            return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)new ArrayList<String>(){
                {
                    this.add(RowNode.printTableRow(headers.stream().map(HeaderNode::inspect)));
                    rows.stream().map(RowNode::inspect).forEach(this::add);
                }
            });
        }

        public void raiseInvalidRowIndex(RowNode firstRow, RowNode invalidRow) {
            throw new SyntaxException("Row index should be consistent", invalidRow.getPositionBegin(), DalException.Position.Type.LINE).multiPosition(firstRow.getPositionBegin(), DalException.Position.Type.LINE);
        }
    }
}

