/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.runtime.Calculator;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.dal.runtime.DataObject;
import com.github.leeonky.util.Converter;
import com.github.leeonky.util.NumberUtil;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AssertionFailure
extends DalException {
    public AssertionFailure(String message, int position) {
        super(message, position);
    }

    public static void assertListSize(int expected, int actual, int position) {
        if (expected != actual) {
            throw new AssertionFailure(String.format("Expecting list size to be <%d> but was <%d>", expected, actual), position);
        }
    }

    public static boolean assertMatchNull(DataObject actual, int position) {
        if (!actual.isNull()) {
            throw new AssertionFailure(String.format("Expecting%sto match null but was not", actual.inspect()), position);
        }
        return true;
    }

    public static boolean assertMatch(DataObject expected, DataObject actual, int position, Converter converter) {
        Object expectedValue = expected.getInstance();
        Object actualValue = actual.getInstance();
        if (expectedValue instanceof Number && actualValue instanceof Number ? NumberUtil.compare((Number)((Number)expectedValue), (Number)((Number)actualValue), (Converter)converter) != 0 : !Calculator.equals(actual.convert(expectedValue.getClass()), expected)) {
            throw new AssertionFailure(String.format("Expecting%sto match%sbut was not", actual.inspect(), expected.inspect()), position);
        }
        return true;
    }

    public static void assertUnexpectedFields(Set<String> dataFields, String element, int position) {
        if (!dataFields.isEmpty()) {
            throw new AssertionFailure(String.format("Unexpected fields %s%s", dataFields.stream().map(s -> String.format("`%s`", s)).collect(Collectors.joining(", ")), element.isEmpty() ? "" : " in " + element), position);
        }
    }

    public static boolean assertEquals(DataObject expected, DataObject actual, int position) {
        if (!Calculator.equals(actual, expected)) {
            throw new AssertionFailure(String.format("Expecting%sto be equal to%sbut was not", actual.inspect(), expected.inspect()), position);
        }
        return true;
    }

    public static boolean assertRegexMatches(Pattern pattern, String actual, int position, DataObject input) {
        if (!pattern.matcher(actual).matches()) {
            throw new AssertionFailure(String.format("Expecting%sto match /%s/ but was not", input.inspect(), pattern), position);
        }
        return true;
    }
}

