/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.runtime.DataObject;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ObjectNode
extends Node {
    private final List<Node> expressions = new ArrayList<Node>();

    public ObjectNode(List<Node> expressions) {
        this.expressions.addAll(expressions);
    }

    public List<Node> getExpressions() {
        return this.expressions;
    }

    public ObjectNode() {
        this(Collections.emptyList());
    }

    @Override
    public String inspect() {
        return String.format("{%s}", this.expressions.stream().map(Node::inspect).collect(Collectors.joining(", ")));
    }

    @Override
    public boolean judge(Node actualNode, Operator.Equal operator, RuntimeContextBuilder.RuntimeContext context) {
        DataObject dataObject = actualNode.evaluateDataObject(context);
        this.checkNull(dataObject);
        if (dataObject.isList()) {
            AtomicInteger integer = new AtomicInteger(0);
            dataObject.getListObjects().forEach(element -> AssertionFailure.assertUnexpectedFields(this.collectUnexpectedFields((DataObject)element), actualNode.inspect() + String.format("[%d]", integer.getAndIncrement()), operator.getPosition()));
        } else {
            AssertionFailure.assertUnexpectedFields(this.collectUnexpectedFields(dataObject), actualNode.inspect(), operator.getPosition());
        }
        return this.judgeAll(context, dataObject);
    }

    private void checkNull(DataObject dataObject) {
        if (dataObject.isNull()) {
            throw new AssertionFailure("The input value is null", this.getPositionBegin());
        }
    }

    private Set<String> collectUnexpectedFields(final DataObject dataObject) {
        return new LinkedHashSet<String>(dataObject.getFieldNames()){
            {
                super(x0);
                this.removeAll(ObjectNode.this.expressions.stream().map(expression -> dataObject.firstFieldFromAlias(expression.getRootName())).collect(Collectors.toSet()));
            }
        };
    }

    @Override
    public boolean judge(Node actualNode, Operator.Matcher operator, RuntimeContextBuilder.RuntimeContext context) {
        DataObject dataObject = actualNode.evaluateDataObject(context);
        this.checkNull(dataObject);
        return this.judgeAll(context, dataObject);
    }

    private boolean judgeAll(RuntimeContextBuilder.RuntimeContext context, DataObject dataObject) {
        return context.newThisScope(dataObject, () -> {
            this.expressions.forEach(expression -> expression.evaluate(context));
            return true;
        });
    }

    @Override
    public int getOperandPosition() {
        return this.expressions.size() > 0 ? this.expressions.get(this.expressions.size() - 1).getOperandPosition() : this.getPositionBegin();
    }
}

