/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class DalException
extends RuntimeException {
    private final List<Position> positions = new ArrayList<Position>();

    protected DalException(String message, int position) {
        this(message, position, Position.Type.CHAR);
    }

    protected DalException(String message, int position, Position.Type type) {
        super(message);
        this.positions.add(new Position(type, position));
    }

    public DalException multiPosition(int positionBegin, Position.Type type) {
        this.positions.add(new Position(type, positionBegin));
        return this;
    }

    @Deprecated
    public int getPosition() {
        return this.positions.get(0).position;
    }

    public String show(String code) {
        return this.show(code, 0);
    }

    public String show(String code, int offset) {
        String result = code.substring(offset);
        this.positions.sort(Comparator.comparingInt(o -> ((Position)o).position).reversed().thenComparing(Comparator.comparing(o -> ((Position)o).type).reversed()));
        for (Position marker : this.positions.stream().map(position -> position.offset(offset)).collect(Collectors.toList())) {
            result = marker.process(result);
        }
        return result;
    }

    public static class Position {
        private final Type type;
        private final int position;

        public Position(Type type, int position) {
            this.type = type;
            this.position = position;
        }

        public String process(String code) {
            int endLineIndex = code.indexOf(10, this.position);
            endLineIndex = endLineIndex == -1 ? code.length() : endLineIndex;
            return code.substring(0, endLineIndex) + "\n" + this.type.markLine(code, this.position, endLineIndex) + code.substring(endLineIndex);
        }

        public Position offset(int offset) {
            return offset == 0 ? this : new Position(this.type, this.position - offset);
        }

        public static enum Type {
            CHAR{

                @Override
                protected String markLine(String code, int position, int endLineIndex) {
                    return String.join((CharSequence)"", Collections.nCopies(position - code.lastIndexOf(10, position) - 1, " ")) + "^";
                }
            }
            ,
            LINE{

                @Override
                protected String markLine(String code, int position, int endLineIndex) {
                    return String.join((CharSequence)"", Collections.nCopies(endLineIndex - code.lastIndexOf(10, position) - 1, "^"));
                }
            };


            protected abstract String markLine(String var1, int var2, int var3);
        }
    }
}

