/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.ast.SortSequenceNode;
import com.github.leeonky.dal.runtime.AutoMappingList;
import com.github.leeonky.dal.runtime.ElementAccessException;
import com.github.leeonky.dal.runtime.Flatten;
import com.github.leeonky.dal.runtime.PropertyAccessException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.SchemaType;
import com.github.leeonky.dal.runtime.SchemaVerifier;
import com.github.leeonky.dal.runtime.ThisObject;
import com.github.leeonky.util.BeanClass;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Data {
    private final SchemaType schemaType;
    private final RuntimeContextBuilder.DALRuntimeContext dalRuntimeContext;
    private final Object instance;
    private List<Object> listValue;
    private Comparator<Object> listComparator = SortSequenceNode.NOP_COMPARATOR;

    public Data(Object instance, RuntimeContextBuilder.DALRuntimeContext context, SchemaType schemaType) {
        this.instance = instance;
        this.schemaType = schemaType;
        this.dalRuntimeContext = context.registerPropertyAccessor(instance);
    }

    public String inspect() {
        return this.isNull() ? "null " : String.format("%s\n<%s>\n", BeanClass.getClassName((Object)this.getInstance()), this.getInstance());
    }

    public Object getInstance() {
        return this.instance;
    }

    public Set<String> getFieldNames() {
        return this.dalRuntimeContext.findPropertyReaderNames(this.instance);
    }

    public boolean isList() {
        return this.dalRuntimeContext.isRegisteredList(this.instance) || this.instance != null && this.instance.getClass().isArray();
    }

    public int getListSize() {
        return this.getListValues().size();
    }

    private List<Object> getListValues() {
        return this.listValue == null ? (this.listValue = StreamSupport.stream(this.dalRuntimeContext.getList(this.instance).spliterator(), false).sorted(this.listComparator).collect(Collectors.toList())) : this.listValue;
    }

    public List<Data> getListObjects() {
        AtomicInteger index = new AtomicInteger(0);
        return this.getListValues().stream().map(object -> new Data(object, this.dalRuntimeContext, this.schemaType.access(index.incrementAndGet()))).collect(Collectors.toList());
    }

    public boolean isNull() {
        return this.dalRuntimeContext.isNull(this.instance);
    }

    public SchemaVerifier createSchemaVerifier() {
        return new SchemaVerifier(this.dalRuntimeContext, this);
    }

    public Data getValue(List<Object> properties) {
        if (properties.isEmpty()) {
            return this;
        }
        return this.getValue(properties.get(0)).getValue(properties.subList(1, properties.size()));
    }

    public Data getValue(Object property) {
        try {
            List<Object> propertyChain = this.schemaType.access(property).getPropertyChainBefore(this.schemaType);
            if (propertyChain.size() == 1 && propertyChain.get(0).equals(property)) {
                return new Data(this.getPropertyValue(property), this.dalRuntimeContext, this.propertySchema(property));
            }
            return this.getValue(propertyChain);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new PropertyAccessException(property, "Index out of bounds (" + ex.getMessage() + ")");
        }
        catch (Exception e) {
            throw new PropertyAccessException(property, String.format("Get property `%s` failed, property can be:\n  1. public field\n  2. public getter\n  3. public no args method\n  4. Map key value\n  5. customized type getter\n  6. static method extension\n%s%s", property, e.getMessage(), this.listMappingMessage(this, property)));
        }
    }

    private String listMappingMessage(Data data, Object symbol) {
        return data.isList() ? String.format("\nImplicit list mapping is not allowed in current version of DAL, use `%s[]` instead", symbol) : "";
    }

    private Object getPropertyValue(Object property) {
        return this.isList() ? this.getValueFromList(property) : this.dalRuntimeContext.getPropertyValue(this, (String)property);
    }

    private Object getValueFromList(Object property) {
        if ("size".equals(property)) {
            return this.getListSize();
        }
        if (property instanceof String) {
            return this.dalRuntimeContext.getPropertyValue(this, (String)property);
        }
        if ((Integer)property < 0) {
            return this.getListValues().get(this.getListSize() + (Integer)property);
        }
        return this.getListValues().get((Integer)property - this.getListFirstIndex());
    }

    public int getListFirstIndex() {
        return this.dalRuntimeContext.getListFirstIndex(this.instance);
    }

    private SchemaType propertySchema(Object property) {
        if (this.isList() && property instanceof String && !"size".equals(property)) {
            return this.schemaType.mappingAccess(property);
        }
        return this.schemaType.access(property);
    }

    public Object firstFieldFromAlias(Object alias) {
        return this.schemaType.firstFieldFromAlias(alias);
    }

    public Data convert(Class<?> target) {
        return new Data(this.dalRuntimeContext.getConverter().convert(target, this.instance), this.dalRuntimeContext, this.schemaType);
    }

    public Data setListComparator(Comparator<Object> listComparator) {
        this.listComparator = listComparator;
        return this;
    }

    public Data mapList(final Object property) {
        return new Data(new AutoMappingList(){
            {
                List<Data> list = Data.this.getListObjects();
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        this.add(list.get(i).getValue(property).getInstance());
                        continue;
                    }
                    catch (PropertyAccessException e) {
                        throw new ElementAccessException(i, e);
                    }
                }
            }
        }, this.dalRuntimeContext, this.propertySchema(property));
    }

    public Data filter(String prefix) {
        FilteredObject filteredObject = new FilteredObject();
        this.getFieldNames().stream().filter((? super T fieldName) -> fieldName.startsWith(prefix)).forEach(fieldName -> filteredObject.put(this.trimPrefix(prefix, (String)fieldName), this.getValue(fieldName).getInstance()));
        return new Data(filteredObject, this.dalRuntimeContext, this.schemaType).setListComparator(this.listComparator);
    }

    private String trimPrefix(String prefix, String fieldName) {
        return fieldName.substring(prefix.length(), prefix.length() + 1).toLowerCase() + fieldName.substring(prefix.length() + 1);
    }

    public Data wrapThis() {
        return new Data(new ThisObject(this), this.dalRuntimeContext, this.schemaType);
    }

    private static class FilteredObject
    extends LinkedHashMap<String, Object>
    implements Flatten {
        private FilteredObject() {
        }
    }
}

