/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.interpreter;

import com.github.leeonky.interpreter.NumberOverflowException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberParser {
    private static final PrimitiveIntegerPostfix BYTE_POSTFIX = new PrimitiveIntegerPostfix(1){

        @Override
        public Number convertFrom(int number, String content) {
            if (number > 127 || number < -128) {
                throw new NumberOverflowException(content);
            }
            return (byte)number;
        }
    };
    private static final PrimitiveIntegerPostfix SHORT_POSTFIX = new PrimitiveIntegerPostfix(1){

        @Override
        public Number convertFrom(int number, String content) {
            if (number > Short.MAX_VALUE || number < Short.MIN_VALUE) {
                throw new NumberOverflowException(content);
            }
            return (short)number;
        }
    };
    private static final PrimitiveIntegerPostfix LONG_POSTFIX = new PrimitiveIntegerPostfix(1){

        @Override
        public Number convertFrom(int number, String content) {
            return (long)number;
        }

        @Override
        public Number convertFrom(long number, String content) {
            return number;
        }
    };
    private static final StringNumberPostfix BIG_INTEGER_POSTFIX = new StringNumberPostfix(2){

        @Override
        public Number convertFromBigInteger(String numberString, int radix, String content) {
            return new BigInteger(numberString, radix);
        }
    };
    private static final StringNumberPostfix FLOAT_POSTFIX = new StringNumberPostfix(1){

        @Override
        public Number convertFromDecimal(String numberString, String content) {
            return this.verifyInfinite(Float.parseFloat(numberString), content);
        }

        private Number verifyInfinite(float f, String content) {
            if (Float.isInfinite(f)) {
                throw new NumberOverflowException(content);
            }
            return Float.valueOf(f);
        }

        @Override
        public Number convertFromBigInteger(String numberString, int radix, String content) {
            return this.verifyInfinite(Float.parseFloat(numberString), content);
        }
    };
    private static final StringNumberPostfix DOUBLE_POSTFIX = new StringNumberPostfix(1){

        @Override
        public Number convertFromDecimal(String numberString, String content) {
            return this.verifyInfinite(Double.parseDouble(numberString), content);
        }

        @Override
        public Number convertFromBigInteger(String numberString, int radix, String content) {
            return this.verifyInfinite(Double.parseDouble(numberString), content);
        }

        private Number verifyInfinite(double d, String content) {
            if (Double.isInfinite(d)) {
                throw new NumberOverflowException(content);
            }
            return d;
        }
    };
    private static final StringNumberPostfix BIG_DECIMAL_POSTFIX = new StringNumberPostfix(2){

        @Override
        public Number convertFromDecimal(String numberString, String content) {
            return new BigDecimal(numberString);
        }

        @Override
        public Number convertFromBigInteger(String numberString, int radix, String content) {
            return new BigDecimal(numberString);
        }
    };

    public Number parse(String content) {
        StringNumberPostfix postfix;
        if (content == null) {
            return null;
        }
        int length = content.length();
        if (length == 0) {
            return null;
        }
        int sign = 1;
        int index = 0;
        char c = content.charAt(index);
        if (c == '+') {
            if (++index == length) {
                return null;
            }
        } else if (c == '-') {
            if (++index == length) {
                return null;
            }
            sign = -1;
        }
        int radix = 10;
        if (index + 1 < length && content.charAt(index) == '0') {
            char radixChar = content.charAt(index + 1);
            if (this.isDigit(radixChar) || radixChar == '_') {
                ++index;
                radix = 8;
            } else if (index + 2 < length) {
                char nextChar;
                if (radixChar == 'x' || radixChar == 'X') {
                    index += 2;
                    radix = 16;
                } else if (!(radixChar != 'b' && radixChar != 'B' || (nextChar = content.charAt(index + 2)) != '0' && nextChar != '1')) {
                    index += 2;
                    radix = 2;
                }
            }
        }
        if ((postfix = this.fetchDecimalOrBigIntegerPostfix(content, radix, c = content.charAt(length - 1))) != null) {
            if (index == (length -= postfix.length)) {
                return null;
            }
            return this.continueParseBigInteger(radix, index, content, length, postfix, this.newStringBuilder(length, sign));
        }
        return this.parseFromInteger(content, length, sign, index, radix, this.fetchOtherPostfix(c));
    }

    private PrimitiveIntegerPostfix fetchOtherPostfix(char c) {
        switch (c) {
            case 'Y': 
            case 'y': {
                return BYTE_POSTFIX;
            }
            case 'S': 
            case 's': {
                return SHORT_POSTFIX;
            }
            case 'L': 
            case 'l': {
                return LONG_POSTFIX;
            }
        }
        return null;
    }

    private StringNumberPostfix fetchDecimalOrBigIntegerPostfix(String content, int radix, char c) {
        if (content.endsWith("bi") || content.endsWith("BI")) {
            return BIG_INTEGER_POSTFIX;
        }
        if (radix == 10) {
            if (content.endsWith("bd") || content.endsWith("BD")) {
                return BIG_DECIMAL_POSTFIX;
            }
            switch (c) {
                case 'F': 
                case 'f': {
                    return FLOAT_POSTFIX;
                }
                case 'D': 
                case 'd': {
                    return DOUBLE_POSTFIX;
                }
            }
        }
        return null;
    }

    private StringBuilder newStringBuilder(int length, int sign) {
        StringBuilder stringBuilder = new StringBuilder(length);
        if (sign == -1) {
            stringBuilder.append('-');
        }
        return stringBuilder;
    }

    private Number parseFromInteger(String content, int length, int sign, int index, int radix, PrimitiveIntegerPostfix postfix) {
        if (postfix != null && index == (length -= postfix.length)) {
            return null;
        }
        int number = 0;
        int limit = sign == 1 ? -2147483647 : Integer.MIN_VALUE;
        int limitBeforeMul = limit / radix;
        while (index < length) {
            char c;
            if ((c = content.charAt(index++)) == '_' && index != length) continue;
            int digit = this.getDigit(radix, c);
            if (digit < 0) {
                if (this.isFloatDot(radix, c, index, length, content)) {
                    return this.parseDoubleWithDot(this.toStringBuilder(radix, sign, number, length), radix, content, index, length, postfix);
                }
                if (this.isPowerChar(radix, c, index, length, content)) {
                    return this.parseDoubleWithPower(content, index, length, this.toStringBuilder(radix, sign, number, length), postfix);
                }
                return null;
            }
            if (this.isOverflow(digit, number, limit, limitBeforeMul, radix)) {
                return this.continueParseLong(sign, radix, number, digit, index, content, length, postfix);
            }
            number = number * radix - digit;
        }
        if (sign == 1) {
            number = -number;
        }
        return postfix != null ? (Number)postfix.convertFrom(number, content) : (Number)number;
    }

    private Number parseDoubleWithPower(String content, int index, int length, StringBuilder stringBuilder, StringNumberPostfix postfix) {
        stringBuilder.append('E');
        int eSign = 1;
        if (content.charAt(index) == '+' && ++index == length) {
            return null;
        }
        if (content.charAt(index) == '-') {
            if (++index == length) {
                return null;
            }
            eSign = -1;
        }
        if (eSign == -1) {
            stringBuilder.append('-');
        }
        while (index < length) {
            char c;
            if ((c = content.charAt(index++)) == '_' && index != length) continue;
            if (this.notDigit(c)) {
                return null;
            }
            stringBuilder.append(c);
        }
        return this.toDoubleOrBigDecimal(stringBuilder, postfix, content);
    }

    private boolean isPowerChar(int radix, char c, int index, int length, String content) {
        return (c == 'e' || c == 'E') && radix == 10 && this.afterDigit(index, content) && this.beforeSignOrDigit(index, length, content);
    }

    private boolean beforeSignOrDigit(int index, int length, String content) {
        if (index >= length) {
            return false;
        }
        char c = content.charAt(index);
        return this.isDigit(c) || c == '-' || c == '+';
    }

    private boolean isFloatDot(int radix, char c, int index, int length, String content) {
        return c == '.' && radix == 10 && this.afterDigit(index, content) && this.beforeDigit(index, length, content);
    }

    private boolean beforeDigit(int index, int length, String content) {
        return index < length && this.isDigit(content.charAt(index));
    }

    private boolean afterDigit(int index, String content) {
        return index > 1 && this.isDigit(content.charAt(index - 2));
    }

    private boolean notDigit(char c) {
        return c < '0' || c > '9';
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private Number parseDoubleWithDot(StringBuilder stringBuilder, int radix, String content, int index, int length, StringNumberPostfix postfix) {
        stringBuilder.append('.');
        while (index < length) {
            char c;
            if ((c = content.charAt(index++)) == '_' && index != length) continue;
            if (this.isPowerChar(radix, c, index, length, content)) {
                return this.parseDoubleWithPower(content, index, length, stringBuilder, postfix);
            }
            if (this.notDigit(c)) {
                return null;
            }
            stringBuilder.append(c);
        }
        return this.toDoubleOrBigDecimal(stringBuilder, postfix, content);
    }

    private Number toDoubleOrBigDecimal(StringBuilder stringBuilder, StringNumberPostfix postfix, String content) {
        String numberString = stringBuilder.toString();
        if (postfix != null) {
            return postfix.convertFromDecimal(numberString, content);
        }
        double d = Double.parseDouble(numberString);
        if (Double.isInfinite(d)) {
            return new BigDecimal(numberString);
        }
        return d;
    }

    private Number continueParseLong(int sign, int radix, long number, int digit, int index, String content, int length, PrimitiveIntegerPostfix postfix) {
        number = number * (long)radix - (long)digit;
        long limitLong = sign == 1 ? -9223372036854775807L : Long.MIN_VALUE;
        long limitBeforeMulLong = limitLong / (long)radix;
        while (index < length) {
            char c;
            if ((c = content.charAt(index++)) == '_' && index != length) continue;
            digit = this.getDigit(radix, c);
            if (digit < 0) {
                if (this.isFloatDot(radix, c, index, length, content)) {
                    return this.parseDoubleWithDot(this.toStringBuilder(radix, sign, number, length), radix, content, index, length, postfix);
                }
                if (this.isPowerChar(radix, c, index, length, content)) {
                    return this.parseDoubleWithPower(content, index, length, this.toStringBuilder(radix, sign, number, length), postfix);
                }
                return null;
            }
            if (this.isOverflow(digit, number, limitLong, limitBeforeMulLong, radix)) {
                return this.continueParseBigInteger(radix, index, content, length, postfix, this.toStringBuilder(radix, sign, number, length).append(c));
            }
            number = number * (long)radix - (long)digit;
        }
        if (sign == 1) {
            number = -number;
        }
        return postfix == null ? (Number)number : (Number)postfix.convertFrom(number, content);
    }

    private Number continueParseBigInteger(int radix, int index, String content, int length, StringNumberPostfix postfix, StringBuilder stringBuilder) {
        while (index < length) {
            char c;
            if ((c = content.charAt(index++)) == '_' && index != length) continue;
            int digit = this.getDigit(radix, c);
            if (digit < 0) {
                if (this.isFloatDot(radix, c, index, length, content)) {
                    return this.parseDoubleWithDot(stringBuilder, radix, content, index, length, postfix);
                }
                if (this.isPowerChar(radix, c, index, length, content)) {
                    return this.parseDoubleWithPower(content, index, length, stringBuilder, postfix);
                }
                return null;
            }
            stringBuilder.append(c);
        }
        return postfix == null ? new BigInteger(stringBuilder.toString(), radix) : postfix.convertFromBigInteger(stringBuilder.toString(), radix, content);
    }

    private StringBuilder toStringBuilder(int radix, int sign, long number, int length) {
        return this.newStringBuilder(length, sign).append(Long.toString(-number, radix));
    }

    private boolean isOverflow(int digit, int number, int limit, int limitBeforeMul, int radix) {
        return number < limitBeforeMul || number * radix < limit + digit;
    }

    private boolean isOverflow(int digit, long number, long limit, long limitBeforeMul, int radix) {
        return number < limitBeforeMul || number * (long)radix < limit + (long)digit;
    }

    private int getDigit(int radix, char c) {
        int value = -1;
        if (c <= '9') {
            value = c - 48;
        } else if (c >= 'a') {
            value = c - 97 + 10;
        } else if (c >= 'A') {
            value = c - 65 + 10;
        }
        if (value >= 0 && value < radix) {
            return value;
        }
        return -1;
    }

    static abstract class PrimitiveIntegerPostfix
    extends StringNumberPostfix {
        protected PrimitiveIntegerPostfix(int length) {
            super(length);
        }

        public abstract Number convertFrom(int var1, String var2);

        public Number convertFrom(long number, String content) {
            throw new NumberOverflowException(content);
        }
    }

    static class StringNumberPostfix {
        public final int length;

        public StringNumberPostfix(int length) {
            this.length = length;
        }

        public Number convertFromBigInteger(String numberString, int radix, String content) {
            throw new NumberOverflowException(content);
        }

        public Number convertFromDecimal(String numberString, String content) {
            throw new NumberOverflowException(content);
        }
    }
}

