/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.table;

import com.github.leeonky.dal.ast.ConstNode;
import com.github.leeonky.dal.ast.DALExpression;
import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.table.IndexRowKeyType;
import com.github.leeonky.dal.ast.table.NoRowKeyType;
import com.github.leeonky.dal.ast.table.PropertyRowKeyType;
import com.github.leeonky.dal.ast.table.RowKeyType;
import com.github.leeonky.dal.compiler.DALProcedure;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.OperatorParser;
import java.util.Optional;

public class RowPrefixNode
extends DALNode {
    private static final RowKeyType NO_ROW_KEY = new NoRowKeyType();
    private static final RowKeyType INDEX_ROW_KEY = new IndexRowKeyType();
    private static final RowKeyType PROPERTY_ROW_KEY = new PropertyRowKeyType();
    private final Optional<DALNode> key;
    private final Optional<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> rowSchema;
    private final Optional<DALOperator> rowOperator;

    public RowPrefixNode(Optional<DALNode> key, Optional<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> rowSchema, Optional<DALOperator> rowOperator) {
        this.rowSchema = rowSchema;
        this.rowOperator = rowOperator;
        this.key = key;
    }

    @Override
    public String inspect() {
        String indexAndSchema = (this.key.map(DALNode::inspect).orElse("") + " " + this.rowSchema.map(clause -> ((DALNode)clause.expression(null)).inspect()).orElse("")).trim();
        return this.rowOperator.map(dalOperator -> dalOperator.inspect(indexAndSchema, "").trim()).orElse(indexAndSchema);
    }

    public DALExpression indexAndSchema(RowKeyType rowKeyType, DALNode input, DALOperator defaultOperator, DALNode data) {
        DALNode inputWithRowKey = rowKeyType.inputWithRowKey(input, this.key);
        return new DALExpression(this.rowSchema.map(clause -> clause.expression(inputWithRowKey)).orElse(inputWithRowKey), this.rowOperator.orElse(defaultOperator), data);
    }

    public OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> rowOperator() {
        return procedure -> this.rowOperator;
    }

    public RowKeyType getRowKeyType() {
        RowKeyType keyType = this.key.map(dalNode -> {
            if (dalNode instanceof ConstNode) {
                return INDEX_ROW_KEY;
            }
            if (dalNode instanceof DALExpression) {
                return PROPERTY_ROW_KEY;
            }
            return NO_ROW_KEY;
        }).orElse(NO_ROW_KEY);
        return keyType;
    }
}

