/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.table;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.SortSequenceNode;
import com.github.leeonky.dal.ast.TableNode;
import com.github.leeonky.dal.ast.table.HeaderNode;
import com.github.leeonky.dal.ast.table.RowNode;
import com.github.leeonky.dal.compiler.DALProcedure;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TableHead
extends DALNode {
    private final List<HeaderNode> headers;

    public TableHead(List<DALNode> headers) {
        this.headers = headers.stream().map(HeaderNode.class::cast).collect(Collectors.toList());
    }

    @Override
    public String inspect() {
        return TableNode.printLine(this.headers);
    }

    public Comparator<Object> collectComparator(RuntimeContextBuilder.DALRuntimeContext context) {
        return this.headers.stream().sorted(HeaderNode.bySequence()).map(headerNode -> headerNode.getListComparator(context)).reduce(Comparator::thenComparing).orElse(SortSequenceNode.NOP_COMPARATOR);
    }

    public int size() {
        return this.headers.size();
    }

    public HeaderNode getHeader(DALProcedure procedure) {
        if (procedure.getIndex() >= this.headers.size()) {
            return new HeaderNode(SortSequenceNode.NO_SEQUENCE, InputNode.INSTANCE, Optional.empty());
        }
        return this.headers.get(procedure.getIndex());
    }

    public void checkSize(RowNode rowNode) {
        if (!rowNode.specialRow() && rowNode.getCells().size() != this.headers.size()) {
            throw new SyntaxException("Different cell size", rowNode.getCells().get(rowNode.getCells().size() - 1).getOperandPosition());
        }
    }
}

