/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.interpreter;

import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.ClauseParser;
import com.github.leeonky.interpreter.Expression;
import com.github.leeonky.interpreter.Node;
import com.github.leeonky.interpreter.Operator;
import com.github.leeonky.interpreter.Parser;
import com.github.leeonky.interpreter.Procedure;
import com.github.leeonky.interpreter.RuntimeContext;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public interface NodeParser<C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>>
extends Parser<C, N, E, O, P, NodeParser<C, N, E, O, P>, Mandatory<C, N, E, O, P>, N> {
    public static <E extends Expression<C, N, E, O>, N extends Node<C, N>, C extends RuntimeContext<C>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> NodeParser<C, N, E, O, P> lazy(Supplier<NodeParser<C, N, E, O, P>> parser) {
        return procedure -> ((NodeParser)parser.get()).parse(procedure);
    }

    @Override
    default public NodeParser<C, N, E, O, P> castParser(Parser<C, N, E, O, P, NodeParser<C, N, E, O, P>, Mandatory<C, N, E, O, P>, N> parser) {
        return parser::parse;
    }

    @Override
    default public Mandatory<C, N, E, O, P> castMandatory(Parser.Mandatory<C, N, E, O, P, NodeParser<C, N, E, O, P>, Mandatory<C, N, E, O, P>, N> mandatory) {
        return mandatory::parse;
    }

    default public ClauseParser<C, N, E, O, P> ignoreInput() {
        return procedure -> this.parse(procedure).map(node -> p -> node);
    }

    default public ClauseParser<C, N, E, O, P> clauseParser(BiFunction<N, N, N> biFunction) {
        return procedure -> this.parse(procedure).map(n -> input -> (Node)biFunction.apply(input, n));
    }

    default public NodeParser<C, N, E, O, P> expression(ClauseParser.Mandatory<C, N, E, O, P> mandatory) {
        return procedure -> this.parse(procedure).map(node -> ((Clause)mandatory.parse(procedure)).expression(node));
    }

    default public NodeParser<C, N, E, O, P> concat(ClauseParser<C, N, E, O, P> clauseParser) {
        return procedure -> this.parse(procedure).map(node -> clauseParser.concated(procedure, node));
    }

    default public NodeParser<C, N, E, O, P> recursive(ClauseParser<C, N, E, O, P> clauseParser) {
        return procedure -> this.parse(procedure).map(node -> clauseParser.recursived(procedure, node));
    }

    default public NodeParser<C, N, E, O, P> withStartPosition() {
        return procedure -> procedure.positionOf(position -> this.parse(procedure).map(node -> node.setPositionBegin((int)position)));
    }

    default public NodeParser<C, N, E, O, P> and(ClauseParser<C, N, E, O, P> clauseParser) {
        return procedure -> procedure.getSourceCode().tryFetch(() -> this.parse(procedure).flatMap(node -> clauseParser.combined(procedure, node)));
    }

    public static interface Mandatory<C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>>
    extends Parser.Mandatory<C, N, E, O, P, NodeParser<C, N, E, O, P>, Mandatory<C, N, E, O, P>, N> {
        @Override
        default public NodeParser<C, N, E, O, P> castParser(Parser<C, N, E, O, P, NodeParser<C, N, E, O, P>, Mandatory<C, N, E, O, P>, N> parser) {
            return parser::parse;
        }

        default public Mandatory<C, N, E, O, P> map(Function<N, N> mapping) {
            return procedure -> (Node)mapping.apply(this.parse(procedure));
        }

        default public Mandatory<C, N, E, O, P> expression(ClauseParser.Mandatory<C, N, E, O, P> clauseMandatory) {
            return procedure -> {
                Node node = (Node)this.parse(procedure);
                return ((Clause)clauseMandatory.parse(procedure)).expression(node);
            };
        }

        default public NodeParser<C, N, E, O, P> combine(ClauseParser<C, N, E, O, P> clauseParser) {
            return procedure -> procedure.getSourceCode().tryFetch(() -> clauseParser.combined(procedure, (Node)this.parse(procedure)));
        }

        default public Mandatory<C, N, E, O, P> concat(ClauseParser<C, N, E, O, P> clauseParser) {
            return procedure -> clauseParser.concated(procedure, (Node)this.parse(procedure));
        }

        default public Mandatory<C, N, E, O, P> recursive(ClauseParser<C, N, E, O, P> clauseParser) {
            return procedure -> clauseParser.recursived(procedure, (Node)this.parse(procedure));
        }

        public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> ClauseParser.Mandatory<C, N, E, O, P> clause(Function<N, Mandatory<C, N, E, O, P>> mandatoryFactory) {
            return procedure -> input -> (Node)((Mandatory)mandatoryFactory.apply(input)).parse(procedure);
        }
    }
}

