/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.Objects;

public class ConstNode
extends DALNode {
    private final Object value;

    public ConstNode(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Object evaluate(RuntimeContextBuilder.DALRuntimeContext context) {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof ConstNode && Objects.equals(this.value, ((ConstNode)obj).value);
    }

    @Override
    public String inspect() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof String) {
            return String.format("'%s'", this.value);
        }
        return this.value.toString();
    }
}

