/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.format.Formatters;
import com.github.leeonky.dal.runtime.AutoMappingList;
import com.github.leeonky.dal.runtime.ClassKeyMap;
import com.github.leeonky.dal.runtime.ConstructorViaSchema;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.Flatten;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import com.github.leeonky.dal.runtime.JavaClassPropertyAccessor;
import com.github.leeonky.dal.runtime.ListAccessor;
import com.github.leeonky.dal.runtime.NameStrategy;
import com.github.leeonky.dal.runtime.PropertyAccessor;
import com.github.leeonky.dal.runtime.Result;
import com.github.leeonky.dal.runtime.SchemaType;
import com.github.leeonky.dal.runtime.UserLiteralRule;
import com.github.leeonky.interpreter.FunctionUtil;
import com.github.leeonky.interpreter.RuntimeContext;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.Converter;
import com.github.leeonky.util.NumberType;
import com.github.leeonky.util.Suppressor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RuntimeContextBuilder {
    private final ClassKeyMap<PropertyAccessor<Object>> propertyAccessors = new ClassKeyMap();
    private final ClassKeyMap<ListAccessor<Object>> listAccessors = new ClassKeyMap();
    private final ClassKeyMap<Function<Object, Object>> objectImplicitMapper = new ClassKeyMap();
    private final Map<String, ConstructorViaSchema> constructors = new LinkedHashMap<String, ConstructorViaSchema>();
    private final Map<String, BeanClass<?>> schemas = new HashMap();
    private Converter converter = Converter.getInstance();
    private final Set<Method> extensionMethods = new HashSet<Method>();
    private final List<UserLiteralRule> userDefinedLiterals = new ArrayList<UserLiteralRule>();
    private final NumberType numberType = new NumberType();
    private final ClassKeyMap<Function<Object, String>> singleDumpers = new ClassKeyMap();
    private final ClassKeyMap<Function<Object, Map<String, Object>>> objectDumpers = new ClassKeyMap();

    public RuntimeContextBuilder() {
        this.registerValueFormat(new Formatters.String()).registerValueFormat(new Formatters.URL()).registerValueFormat(new Formatters.Instant()).registerValueFormat(new Formatters.LocalDate()).registerValueFormat(new Formatters.LocalDateTime()).registerValueFormat(new Formatters.Enum()).registerValueFormat(new Formatters.Number()).registerValueFormat(new Formatters.PositiveInteger()).registerValueFormat(new Formatters.Integer()).registerValueFormat(new Formatters.PositiveNumber()).registerValueFormat(new Formatters.ZeroNumber()).registerValueFormat(new Formatters.Boolean()).registerSchema("List", Data::isList).registerListAccessor(Iterable.class, iterable -> iterable).registerListAccessor(Stream.class, stream -> stream::iterator).registerPropertyAccessor(Map.class, new MapPropertyAccessor()).registerPropertyAccessor(AutoMappingList.class, new AutoMappingListPropertyAccessor());
        this.registerSingleDumper(String.class, RuntimeContextBuilder::dumpString).registerSingleDumper(Number.class, Object::toString).registerSingleDumper(Boolean.class, Object::toString).registerSingleDumper(Boolean.TYPE, Object::toString);
        this.registerObjectDumper(UUID.class, Object::toString).registerObjectDumper(Instant.class, Object::toString).registerObjectDumper(Date.class, date -> date.toInstant().toString()).registerObjectDumper(LocalTime.class, LocalTime::toString).registerObjectDumper(LocalDate.class, LocalDate::toString).registerObjectDumper(LocalDateTime.class, LocalDateTime::toString).registerObjectDumper(OffsetDateTime.class, OffsetDateTime::toString).registerObjectDumper(ZonedDateTime.class, ZonedDateTime::toString).registerObjectDumper(YearMonth.class, YearMonth::toString).registerObjectDumper(Class.class, Class::getName);
    }

    public <T> RuntimeContextBuilder registerSingleDumper(Class<T> key, Function<T, String> toString) {
        this.singleDumpers.put(key, obj -> (String)toString.apply(obj));
        return this;
    }

    public <T> RuntimeContextBuilder registerObjectDumper(Class<T> type, final Function<T, String> toString) {
        this.objectDumpers.put(type, obj -> new LinkedHashMap<String, Object>(){
            {
                this.put("__type", obj.getClass().getName());
                this.put("__value", toString.apply(obj));
            }
        });
        return this;
    }

    private static String dumpString(Object o) {
        return "\"" + o.toString().replace("\\", "\\\\").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("'", "\\'").replace("\"", "\\\"") + "\"";
    }

    public DALRuntimeContext build(Object inputValue) {
        return new DALRuntimeContext(inputValue);
    }

    public RuntimeContextBuilder registerValueFormat(Formatter<?, ?> formatter) {
        return this.registerValueFormat(formatter.getFormatterName(), formatter);
    }

    public RuntimeContextBuilder registerValueFormat(String name, Formatter<?, ?> formatter) {
        this.constructors.put(name, o -> formatter.transform(o.getInstance()));
        return this;
    }

    public RuntimeContextBuilder registerSchema(Class<?> schema) {
        return this.registerSchema(NameStrategy.SIMPLE_NAME, schema);
    }

    public RuntimeContextBuilder registerSchema(String name, Class<?> schema) {
        this.schemas.put(name, BeanClass.create(schema));
        return this.registerSchema(name, (Data data) -> data.createSchemaVerifier().verify(schema, null, ""));
    }

    public RuntimeContextBuilder registerSchema(String name, Function<Data, Boolean> predicate) {
        this.constructors.put(name, o -> {
            if (((Boolean)predicate.apply((Data)o)).booleanValue()) {
                return o.getInstance();
            }
            throw new IllegalTypeException();
        });
        return this;
    }

    public <T> RuntimeContextBuilder registerPropertyAccessor(Class<T> type, PropertyAccessor<? extends T> propertyAccessor) {
        this.propertyAccessors.put(type, propertyAccessor);
        return this;
    }

    public <T> RuntimeContextBuilder registerListAccessor(Class<T> type, ListAccessor<? extends T> listAccessor) {
        this.listAccessors.put(type, listAccessor);
        return this;
    }

    public RuntimeContextBuilder registerSchema(NameStrategy nameStrategy, Class<?> schema) {
        return this.registerSchema(nameStrategy.toName(schema), schema);
    }

    public RuntimeContextBuilder setConverter(Converter converter) {
        this.converter = converter;
        return this;
    }

    public RuntimeContextBuilder registerStaticMethodExtension(Class<?> staticMethodExtensionClass) {
        Stream.of(staticMethodExtensionClass.getMethods()).filter(this::maybeExtensionMethods).forEach(this.extensionMethods::add);
        return this;
    }

    public <T> RuntimeContextBuilder registerImplicitData(Class<T> type, Function<T, Object> mapper) {
        this.objectImplicitMapper.put(type, mapper);
        return this;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public RuntimeContextBuilder registerUserDefinedLiterals(UserLiteralRule rule) {
        this.userDefinedLiterals.add(rule);
        return this;
    }

    public Object invokeExtensionMethod(Object instance, String name, String typeName) {
        Optional optionalMethod = FunctionUtil.oneOf(() -> this.findExtensionMethod(instance, name, Object::equals), () -> this.findExtensionMethod(instance, name, Class::isAssignableFrom));
        if (optionalMethod.isPresent()) {
            return Suppressor.get(() -> ((Method)optionalMethod.get()).invoke(null, instance));
        }
        Optional<Function<Object, Object>> mapper = this.objectImplicitMapper.tryGetData(instance);
        if (mapper.isPresent()) {
            return this.invokeExtensionMethod(mapper.get().apply(instance), name, typeName);
        }
        throw new IllegalStateException(String.format("Method or property `%s` does not exist in `%s`", name, typeName));
    }

    private Optional<Method> findExtensionMethod(Object instance, String name, BiPredicate<Class<?>, Class<?>> condition) {
        Stream<Method> methodStream = this.extensionMethods.stream().filter(method -> method.getName().equals(name) && condition.test(method.getParameterTypes()[0], instance.getClass()));
        List methods = methodStream.collect(Collectors.toList());
        if (methods.size() > 1) {
            throw new IllegalStateException("Ambiguous method call:\n" + methods.stream().map(Method::toString).collect(Collectors.joining("\n")));
        }
        return methods.stream().findFirst();
    }

    private boolean maybeExtensionMethods(Method method) {
        return method.getParameterCount() == 1 && this.isMethod(method, 8) && this.isMethod(method, 1);
    }

    private boolean isMethod(Method method, int modifier) {
        return (modifier & method.getModifiers()) != 0;
    }

    private class AutoMappingListPropertyAccessor
    extends JavaClassPropertyAccessor<AutoMappingList> {
        public AutoMappingListPropertyAccessor() {
            super(RuntimeContextBuilder.this, BeanClass.create(AutoMappingList.class));
        }

        @Override
        public Object getValueByData(Data data, String name) {
            return data.mapList(name).getInstance();
        }
    }

    static class FlattenData {
        final Data instance;
        final Object prefix;
        final Set<Object> postfixes = new HashSet<Object>();
        final FlattenDataCollection children = new FlattenDataCollection();

        public FlattenData(Data instance, Object prefix) {
            this.instance = instance;
            this.prefix = prefix;
        }

        public Set<String> removeFlattenProperties(Data data) {
            this.postfixes.addAll(this.children.removeFlattenProperties(this.instance));
            return this.postfixes.stream().map(property -> ((Flatten)this.instance.getInstance()).removeExpectedField(data.getFieldNames(), this.prefix, property)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        }
    }

    static class FlattenDataCollection {
        private final Map<Data, FlattenData> collection = new HashMap<Data, FlattenData>();

        FlattenDataCollection() {
        }

        public void initFlattenData(Data instance, Object prefix) {
            this.collection.put(instance, new FlattenData(instance, prefix));
        }

        public FlattenData fetchFlattenData(Data data) {
            FlattenData flattenData = this.collection.get(data);
            if (flattenData == null) {
                flattenData = this.collection.values().stream().map(subFlattenData -> subFlattenData.children.fetchFlattenData(data)).filter(Objects::nonNull).findFirst().orElse(null);
            }
            return flattenData;
        }

        public Set<String> removeFlattenProperties(Data data) {
            return this.collection.values().stream().flatMap(flattenData -> flattenData.removeFlattenProperties(data).stream()).collect(Collectors.toSet());
        }
    }

    public class DALRuntimeContext
    implements RuntimeContext<DALRuntimeContext> {
        private final LinkedList<Data> stack = new LinkedList();
        private final Set<Class<?>> schemaSet;
        private final Map<Data, FlattenDataCollection> flattenDataMap;

        public DALRuntimeContext(Object inputValue) {
            this.schemaSet = RuntimeContextBuilder.this.schemas.values().stream().map(BeanClass::getType).collect(Collectors.toSet());
            this.stack.push(this.wrap(inputValue));
            this.flattenDataMap = new HashMap<Data, FlattenDataCollection>();
        }

        public Data getThis() {
            return this.stack.getFirst();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T newBlockScope(Data data, Supplier<T> supplier) {
            try {
                this.stack.push(data);
                T t = supplier.get();
                return t;
            }
            finally {
                this.stack.pop();
            }
        }

        public Optional<ConstructorViaSchema> searchConstructor(String type) {
            return Optional.ofNullable(RuntimeContextBuilder.this.constructors.get(type));
        }

        public boolean isSchemaRegistered(Class<?> fieldType) {
            return this.schemaSet.contains(fieldType);
        }

        public Set<String> findPropertyReaderNames(Object instance) {
            return ((PropertyAccessor)RuntimeContextBuilder.this.propertyAccessors.getData(instance)).getPropertyNames(instance);
        }

        public Boolean isNull(Object instance) {
            return RuntimeContextBuilder.this.propertyAccessors.tryGetData(instance).map(f -> f.isNull(instance)).orElseGet(() -> Objects.equals(instance, null));
        }

        public Object getPropertyValue(Data data, String name) {
            return ((PropertyAccessor)RuntimeContextBuilder.this.propertyAccessors.getData(data.getInstance())).getValueByData(data, name);
        }

        public Iterable<Object> getList(Object instance) {
            return RuntimeContextBuilder.this.listAccessors.tryGetData(instance).map(l -> l.toIterable(instance)).orElseGet(() -> this.arrayIterable(instance));
        }

        public int getListFirstIndex(Object instance) {
            return RuntimeContextBuilder.this.listAccessors.tryGetData(instance).map(ListAccessor::firstIndex).orElse(0);
        }

        private Iterable<Object> arrayIterable(final Object instance) {
            return () -> new Iterator<Object>(){
                private final int length;
                private int index;
                {
                    this.length = Array.getLength(instance);
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.length;
                }

                @Override
                public Object next() {
                    return Array.get(instance, this.index++);
                }
            };
        }

        public boolean isRegisteredList(Object instance) {
            Optional objectListAccessor = RuntimeContextBuilder.this.listAccessors.tryGetData(instance);
            return objectListAccessor.isPresent() && ((ListAccessor)objectListAccessor.get()).isList(instance);
        }

        public Converter getConverter() {
            return RuntimeContextBuilder.this.converter;
        }

        public Data wrap(Object instance) {
            return new Data(instance, this, SchemaType.createRoot());
        }

        public Data wrap(Object instance, String schema, boolean isList) {
            BeanClass schemaBeanClass = (BeanClass)RuntimeContextBuilder.this.schemas.get(schema);
            if (isList) {
                schemaBeanClass = BeanClass.create(Array.newInstance(schemaBeanClass.getType(), 0).getClass());
            }
            return new Data(instance, this, SchemaType.create(schemaBeanClass));
        }

        public <T> DALRuntimeContext registerPropertyAccessor(T instance) {
            if (!Objects.equals(instance, null) && !RuntimeContextBuilder.this.propertyAccessors.containsType(instance)) {
                RuntimeContextBuilder.this.propertyAccessors.put(BeanClass.getClass(instance), new JavaClassPropertyAccessor(RuntimeContextBuilder.this, BeanClass.createFrom(instance)));
            }
            return this;
        }

        public Optional<Result> takeUserDefinedLiteral(String token) {
            return RuntimeContextBuilder.this.userDefinedLiterals.stream().map(userLiteralRule -> userLiteralRule.compile(token)).filter(Result::hasResult).findFirst();
        }

        public void appendFlattenProperty(Data data, Object symbol) {
            this.fetchFlattenData(data).map(flattenData -> flattenData.postfixes.add(symbol));
        }

        private Optional<FlattenData> fetchFlattenData(Data data) {
            return this.flattenDataMap.values().stream().map(flattenDataCollection -> flattenDataCollection.fetchFlattenData(data)).filter(Objects::nonNull).findFirst();
        }

        public void setFlattenProperty(Data parent, Object prefix, Data property) {
            FlattenDataCollection flattenDataCollection = this.flattenDataMap.get(parent);
            if (flattenDataCollection == null) {
                flattenDataCollection = this.fetchFlattenData(parent).map(flattenData -> flattenData.children).orElse(null);
            }
            if (flattenDataCollection == null) {
                flattenDataCollection = new FlattenDataCollection();
                this.flattenDataMap.put(parent, flattenDataCollection);
            }
            flattenDataCollection.initFlattenData(property, prefix);
        }

        public Set<String> removeFlattenProperties(Data parent) {
            FlattenDataCollection flattenDataCollection = this.flattenDataMap.get(parent);
            if (flattenDataCollection != null) {
                return flattenDataCollection.removeFlattenProperties(parent);
            }
            return this.fetchFlattenData(parent).map(flattenData -> flattenData.children.removeFlattenProperties(parent)).orElse(Collections.emptySet());
        }

        public NumberType getNumberType() {
            return RuntimeContextBuilder.this.numberType;
        }

        public Optional<Function<Object, String>> fetchSingleDumper(Object instance) {
            return RuntimeContextBuilder.this.singleDumpers.tryGetData(instance);
        }

        public Optional<Function<Object, Map<String, Object>>> fetchObjectDumper(Object instance) {
            return RuntimeContextBuilder.this.objectDumpers.tryGetData(instance);
        }
    }

    private static class MapPropertyAccessor
    implements PropertyAccessor<Map<String, ?>> {
        private MapPropertyAccessor() {
        }

        @Override
        public Object getValue(Map<String, ?> instance, String name) {
            return instance.get(name);
        }

        @Override
        public Set<String> getPropertyNames(Map<String, ?> instance) {
            return instance.keySet();
        }

        @Override
        public boolean isNull(Map<String, ?> instance) {
            return instance == null;
        }
    }
}

