/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.DALExpression;
import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.ListEllipsisNode;
import com.github.leeonky.dal.ast.PropertyThis;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectScopeNode
extends DALNode {
    private final List<DALNode> expressions = new ArrayList<DALNode>();
    private final boolean isObjectWildcard;

    public ObjectScopeNode(List<DALNode> expressions) {
        this.expressions.addAll(expressions);
        this.isObjectWildcard = false;
    }

    public ObjectScopeNode(DALNode node) {
        ListEllipsisNode ignore = (ListEllipsisNode)node;
        this.isObjectWildcard = true;
    }

    @Override
    public String inspect() {
        return String.format("{%s}", this.isObjectWildcard ? "..." : this.expressions.stream().map(DALNode::inspect).collect(Collectors.joining(", ")));
    }

    @Override
    protected boolean verify(final Data data, DALOperator.Equal operator, final RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        this.checkNull(data);
        return context.newBlockScope(data, () -> {
            this.expressions.forEach(expression -> expression.evaluate(context));
            LinkedHashSet<String> unexpectedFields = new LinkedHashSet<String>(data.getFieldNames()){
                {
                    super(x0);
                    this.removeAll(ObjectScopeNode.this.collectFields(data));
                    this.removeAll(context.removeFlattenProperties(data));
                }
            };
            AssertionFailure.assertUnexpectedFields((Set<String>)unexpectedFields, actualNode.inspect(), operator.getPosition());
            return true;
        });
    }

    @Override
    protected boolean verify(Data data, DALOperator.Matcher operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        if (this.expressions.isEmpty() && !this.isObjectWildcard) {
            throw new SyntaxException("Should use `{...}` to verify any non null object", this.getPositionBegin());
        }
        this.checkNull(data);
        return context.newBlockScope(data, () -> {
            this.expressions.forEach(expression -> expression.evaluate(context));
            return true;
        });
    }

    private void checkNull(Data data) {
        if (data.isNull()) {
            throw new AssertionFailure("The input value is null", this.getPositionBegin());
        }
    }

    private Set<Object> collectFields(Data data) {
        return this.expressions.stream().flatMap(expression -> {
            DALNode expectedNode;
            DALNode keyNode = ((DALExpression)((DALExpression)expression).getLeftOperand()).getRightOperand();
            if (keyNode instanceof PropertyThis && (expectedNode = ((DALExpression)expression).getRightOperand()) instanceof ObjectScopeNode) {
                return ((ObjectScopeNode)expectedNode).collectFields(data).stream();
            }
            return Stream.of(data.firstFieldFromAlias(expression.getRootSymbolName()));
        }).collect(Collectors.toSet());
    }
}

