/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.table;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.TableNode;
import com.github.leeonky.dal.ast.table.RowPrefixNode;
import com.github.leeonky.dal.ast.table.TransposedRowNode;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TransposedTableHead
extends DALNode {
    private final List<RowPrefixNode> prefixes;

    public TransposedTableHead(List<DALNode> prefixes) {
        this.prefixes = prefixes.stream().map(RowPrefixNode.class::cast).collect(Collectors.toList());
        if (!prefixes.isEmpty()) {
            this.setPositionBegin(prefixes.get(prefixes.size() - 1).getPositionBegin());
        }
    }

    @Override
    public String inspect() {
        return "| >> " + TableNode.printLine(this.prefixes) + "\n";
    }

    public RowPrefixNode getPrefix(int i) {
        if (i >= this.prefixes.size()) {
            return new RowPrefixNode(Optional.empty(), Optional.empty(), Optional.empty());
        }
        return this.prefixes.get(i);
    }

    public void checkSize(TransposedRowNode r) {
        if (r.cellCount() != this.prefixes.size()) {
            throw new SyntaxException("Different cell size", this.getPositionBegin(), InterpreterException.Position.Type.LINE);
        }
    }
}

