/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.interpreter;

import com.github.leeonky.interpreter.SyntaxException;
import com.github.leeonky.util.NumberParser;
import java.math.BigInteger;

public class Token {
    private final StringBuilder content;
    private final int position;
    private static final NumberParser NUMBER_PARSER = new NumberParser();

    public int getPosition() {
        return this.position;
    }

    public Token(int position) {
        this.position = position;
        this.content = new StringBuilder();
    }

    public Number getInteger() {
        Class<?> type;
        Number number = this.getNumber();
        if (number != null && ((type = number.getClass()).equals(Integer.class) || type.equals(Long.class) || type.equals(Short.class) || type.equals(Byte.class) || type.equals(BigInteger.class))) {
            return number;
        }
        throw new SyntaxException("expect an integer", this.position);
    }

    public Number getNumber() {
        return NUMBER_PARSER.parse(this.getContent());
    }

    public String getContent() {
        return this.content.toString();
    }

    public void append(char c) {
        this.content.append(c);
    }

    public Token append(String str) {
        this.content.append(str);
        return this;
    }

    public boolean isNumber() {
        return this.getNumber() != null;
    }
}

