/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.table;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.ListEllipsisNode;
import com.github.leeonky.dal.ast.TableNode;
import com.github.leeonky.dal.ast.WildcardNode;
import com.github.leeonky.dal.ast.table.EmptyCellNode;
import com.github.leeonky.dal.ast.table.HeaderNode;
import com.github.leeonky.dal.ast.table.TableHeadRow;
import com.github.leeonky.dal.ast.table.TableRowNode;
import com.github.leeonky.dal.ast.table.TransposedTableHead;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TransposedRowNode
extends DALNode {
    private final HeaderNode headerNode;
    private final List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> cellClauses;

    public TransposedRowNode(DALNode header, List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> clauses) {
        this.cellClauses = clauses;
        this.headerNode = (HeaderNode)header;
        this.setPositionBegin(header.getPositionBegin());
    }

    @Override
    public String inspect() {
        return TableNode.printLine((List<? extends DALNode>)new ArrayList<DALNode>(){
            {
                this.add(TransposedRowNode.this.headerNode);
                this.addAll(TransposedRowNode.this.cellClauses.stream().map(clause -> (DALNode)clause.expression((Node)InputNode.INPUT_NODE)).collect(Collectors.toList()));
            }
        });
    }

    public List<TableRowNode> transpose(final TransposedTableHead transposedTableHead) {
        return new ArrayList<TableRowNode>(){
            {
                for (int i = 0; i < TransposedRowNode.this.cellClauses.size(); ++i) {
                    this.add(new TableRowNode((DALNode)transposedTableHead.getPrefix(i), Collections.singletonList(TransposedRowNode.this.cellClauses.get(i)), new TableHeadRow(Collections.singletonList(TransposedRowNode.this.headerNode))));
                }
            }
        };
    }

    public HeaderNode getHeader() {
        return this.headerNode;
    }

    public int cellCount() {
        return this.cellClauses.size();
    }

    public void replaceEmptyCell(TransposedRowNode firstRow) {
        for (int i = 0; i < firstRow.cellClauses.size(); ++i) {
            DALNode row = (DALNode)firstRow.cellClauses.get(i).expression((Node)InputNode.INPUT_NODE);
            if (!(row instanceof WildcardNode) && !(row instanceof ListEllipsisNode)) continue;
            this.cellClauses.set(i, (Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>)((Clause)node -> new EmptyCellNode()));
        }
    }
}

