/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.util.Classes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class ClassKeyMap<T>
extends LinkedHashMap<Class<?>, T> {
    public Optional<T> tryGetData(Object object) {
        if (object == null) {
            return Optional.empty();
        }
        Object data = this.get(object.getClass());
        if (data != null) {
            return Optional.of(data);
        }
        return this.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(object)).sorted(Map.Entry.comparingByKey(Classes::compareByExtends)).map(Map.Entry::getValue).findFirst();
    }

    public boolean containsType(Object object) {
        return this.tryGetData(object).isPresent();
    }

    public T getData(Object instance) {
        return this.tryGetData(instance).orElseThrow(IllegalArgumentException::new);
    }

    @Override
    public T put(Class<?> key, T value) {
        return super.put(key, value);
    }
}

