/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.inspector;

import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.inspector.CacheableInspector;
import com.github.leeonky.dal.runtime.inspector.InspectorCache;
import com.github.leeonky.dal.util.TextUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ListInspector
extends CacheableInspector {
    public ListInspector(Data data) {
        super(data);
    }

    @Override
    public String cachedInspect(String path, InspectorCache cache) {
        List<Data> dataList = this.data.getDataList();
        if (dataList.isEmpty()) {
            return "[]";
        }
        AtomicInteger index = new AtomicInteger(0);
        return dataList.stream().map(data1 -> data1.buildInspector().dump(path + "[" + index.getAndIncrement() + "]", cache)).map(TextUtil::indent).collect(Collectors.joining(",\n", "[\n", "\n]"));
    }
}

